/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.cipher.CipherException;

public abstract class DecryptStreamCallback
implements StreamCallback {
    private static final int BUFFER_LENGTH = 4096;
    private static final int BUFFER_INPUT_OFFSET = 0;
    private static final int END_OF_FILE = -1;
    private final Cipher cipher;
    private final int parameterBufferLength;

    public DecryptStreamCallback(Cipher cipher, int parameterBufferLength) {
        this.cipher = cipher;
        this.parameterBufferLength = parameterBufferLength;
    }

    public void process(InputStream inputStream, OutputStream outputStream) throws IOException {
        ByteBuffer parameterBuffer = this.readParameterBuffer(inputStream);
        AlgorithmParameterSpec algorithmParameterSpec = this.readAlgorithmParameterSpec(parameterBuffer);
        Key key = this.getKey(algorithmParameterSpec);
        this.initCipher(key, algorithmParameterSpec);
        this.processBuffer(parameterBuffer, outputStream);
        this.processStream(inputStream, outputStream);
    }

    protected abstract AlgorithmParameterSpec readAlgorithmParameterSpec(ByteBuffer var1);

    protected abstract Key getKey(AlgorithmParameterSpec var1);

    private void initCipher(Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            this.cipher.init(2, key, algorithmParameterSpec);
        }
        catch (GeneralSecurityException e) {
            String message = String.format("Cipher [%s] initialization failed", this.cipher.getAlgorithm());
            throw new CipherException(message, e);
        }
    }

    private ByteBuffer readParameterBuffer(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[this.parameterBufferLength];
        int read = inputStream.read(buffer);
        if (read == -1) {
            throw new EOFException("Read parameters buffer failed");
        }
        return ByteBuffer.wrap(buffer, 0, read);
    }

    private void processBuffer(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        if (byteBuffer.hasRemaining()) {
            int remaining = byteBuffer.remaining();
            byte[] buffer = new byte[remaining];
            byteBuffer.get(buffer);
            this.processBytes(buffer, remaining, outputStream);
        }
    }

    private void processBytes(byte[] buffer, int length, OutputStream outputStream) throws IOException {
        byte[] deciphered = this.cipher.update(buffer, 0, length);
        if (deciphered != null) {
            outputStream.write(deciphered);
        }
    }

    private void processStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = inputStream.read(buffer)) != -1) {
            this.processBytes(buffer, read, outputStream);
        }
        try {
            byte[] deciphered = this.cipher.doFinal();
            outputStream.write(deciphered);
        }
        catch (GeneralSecurityException e) {
            String message = String.format("Cipher [%s] verification failed", this.cipher.getAlgorithm());
            throw new CipherException(message, e);
        }
    }
}

