/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher.compatibility;

import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.processors.cipher.algorithm.DigestAlgorithm;
import org.apache.nifi.processors.cipher.algorithm.SymmetricCipher;

public enum CompatibilityModeEncryptionScheme implements DescribedValue
{
    PBE_WITH_MD5_AND_AES_CBC_128("PBEWITHMD5AND128BITAES-CBC-OPENSSL", DigestAlgorithm.MD5, SymmetricCipher.AES, "PKCS12 with MD5 digest and Advanced Encryption Standard in Cipher Block Chaining mode using 128 bit keys."),
    PBE_WITH_MD5_AND_AES_CBC_192("PBEWITHMD5AND192BITAES-CBC-OPENSSL", DigestAlgorithm.MD5, SymmetricCipher.AES, "PKCS12 with MD5 digest and Advanced Encryption Standard in Cipher Block Chaining mode using 192 bit keys."),
    PBE_WITH_MD5_AND_AES_CBC_256("PBEWITHMD5AND256BITAES-CBC-OPENSSL", DigestAlgorithm.MD5, SymmetricCipher.AES, "PKCS12 with MD5 digest and Advanced Encryption Standard in Cipher Block Chaining mode using 256 bit keys."),
    PBE_WITH_MD5_AND_DES("PBEWITHMD5ANDDES", DigestAlgorithm.MD5, SymmetricCipher.DES, "PKCS5 Scheme 1 with MD5 digest and Data Encryption Standard 64 bit keys. OID 1.2.840.113549.1.5.3"),
    PBE_WITH_MD5_AND_RC2("PBEWITHMD5ANDRC2", DigestAlgorithm.MD5, SymmetricCipher.RC2, "PKCS Scheme 1 with MD5 digest and Rivest Cipher 2. OID 1.2.840.113549.1.5.6"),
    PBE_WITH_SHA1_AND_AES_CBC_128("PBEWITHSHAAND128BITAES-CBC-BC", DigestAlgorithm.SHA1, SymmetricCipher.AES, "PKCS12 with SHA-1 digest and Advanced Encryption Standard in Cipher Block Chaining mode using 128 bit keys."),
    PBE_WITH_SHA1_AND_AES_CBC_192("PBEWITHSHAAND192BITAES-CBC-BC", DigestAlgorithm.SHA1, SymmetricCipher.AES, "PKCS12 with SHA-1 digest and Advanced Encryption Standard in Cipher Block Chaining mode using 192 bit keys."),
    PBE_WITH_SHA1_AND_AES_CBC_256("PBEWITHSHAAND256BITAES-CBC-BC", DigestAlgorithm.SHA1, SymmetricCipher.AES, "PKCS12 with SHA-1 digest and Advanced Encryption Standard in Cipher Block Chaining mode using 256 bit keys."),
    PBE_WITH_SHA1_AND_DES("PBEWITHSHA1ANDDES", DigestAlgorithm.SHA1, SymmetricCipher.DES, "PKCS5 Scheme 1 with SHA-1 digest and Data Encryption Standard. OID 1.2.840.113549.1.5.10"),
    PBE_WITH_SHA1_AND_DESEDE_128("PBEWITHSHAAND2-KEYTRIPLEDES-CBC", DigestAlgorithm.SHA1, SymmetricCipher.DESEDE, "PKCS12 with SHA-1 digest and Triple Data Encryption Standard 128 bit keys. OID 1.2.840.113549.1.12.1.4"),
    PBE_WITH_SHA1_AND_DESEDE_192("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", DigestAlgorithm.SHA1, SymmetricCipher.DESEDE, "PKCS12 with SHA-1 digest and Triple Data Encryption Standard 192 bit keys. OID 1.2.840.113549.1.12.1.3"),
    PBE_WITH_SHA1_AND_RC2("PBEWITHSHA1ANDRC2", DigestAlgorithm.SHA1, SymmetricCipher.RC2, "PKCS5 Scheme 1 with SHA-1 digest and Rivest Cipher 2. OID 1.2.840.113549.1.5.11"),
    PBE_WITH_SHA1_AND_RC2_128("PBEWITHSHAAND128BITRC2-CBC", DigestAlgorithm.SHA1, SymmetricCipher.RC2, "PKCS12 with SHA-1 digest and Rivest Cipher 2 128 bit keys. OID 1.2.840.113549.1.12.1.5"),
    PBE_WITH_SHA1_AND_RC2_40("PBEWITHSHAAND40BITRC2-CBC", DigestAlgorithm.SHA1, SymmetricCipher.RC2, "PKCS12 with SHA-1 digest and Rivest Cipher 2 40 bit keys. OID 1.2.840.113549.1.12.1.6"),
    PBE_WITH_SHA1_AND_RC4_128("PBEWITHSHAAND128BITRC4", DigestAlgorithm.SHA1, SymmetricCipher.RC4, "PKCS12 with SHA-1 digest and Rivest Cipher 4 128 bit keys. OID 1.2.840.113549.1.12.1.1"),
    PBE_WITH_SHA1_AND_RC4_40("PBEWITHSHAAND40BITRC4", DigestAlgorithm.SHA1, SymmetricCipher.RC4, "PKCS12 with SHA-1 digest and Rivest Cipher 4 40 bit keys. OID 1.2.840.113549.1.12.1.2"),
    PBE_WITH_SHA1_AND_TWOFISH("PBEWITHSHAANDTWOFISH-CBC", DigestAlgorithm.SHA1, SymmetricCipher.TWOFISH, "PKCS12 with SHA-1 digest and Twofish in Cipher Block Chaining mode using 256 bit keys."),
    PBE_WITH_SHA256_AND_AES_CBC_128("PBEWITHSHA256AND128BITAES-CBC-BC", DigestAlgorithm.SHA256, SymmetricCipher.AES, "PKCS12 with SHA-256 digest and Advanced Encryption Standard in Cipher Block Chaining mode using 128 bit keys."),
    PBE_WITH_SHA256_AND_AES_CBC_192("PBEWITHSHA256AND192BITAES-CBC-BC", DigestAlgorithm.SHA256, SymmetricCipher.AES, "PKCS12 with SHA-256 digest and Advanced Encryption Standard in Cipher Block Chaining mode using 192 bit keys."),
    PBE_WITH_SHA256_AND_AES_CBC_256("PBEWITHSHA256AND256BITAES-CBC-BC", DigestAlgorithm.SHA256, SymmetricCipher.AES, "PKCS12 with SHA-256 digest and Advanced Encryption Standard in Cipher Block Chaining mode using 256 bit keys.");

    private final String algorithm;
    private final String description;
    private final DigestAlgorithm digestAlgorithm;
    private final SymmetricCipher symmetricCipher;

    private CompatibilityModeEncryptionScheme(String algorithm, DigestAlgorithm digestAlgorithm, SymmetricCipher symmetricCipher, String description) {
        this.algorithm = algorithm;
        this.description = description;
        this.digestAlgorithm = digestAlgorithm;
        this.symmetricCipher = symmetricCipher;
    }

    public String getValue() {
        return this.algorithm;
    }

    public String getDisplayName() {
        return this.name();
    }

    public String getDescription() {
        return this.description;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public SymmetricCipher getSymmetricCipher() {
        return this.symmetricCipher;
    }
}

