/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher.age;

import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import org.bouncycastle.shaded.jce.provider.BouncyCastleProvider;

public final class AgeProviderResolver {
    private static final String KEY_ALGORITHM_FILTER = "KeyFactory.X25519";
    private static final String CIPHER_ALGORITHM_FILTER = "Cipher.ChaCha20-Poly1305";

    private AgeProviderResolver() {
    }

    public static Provider getCipherProvider() {
        Provider[] providers = Security.getProviders(CIPHER_ALGORITHM_FILTER);
        Object cipherProvider = providers == null ? new BouncyCastleProvider() : providers[0];
        return cipherProvider;
    }

    public static Optional<Provider> getKeyProvider() {
        Provider[] providers = Security.getProviders(KEY_ALGORITHM_FILTER);
        BouncyCastleProvider keyProvider = providers == null ? new BouncyCastleProvider() : null;
        return Optional.ofNullable(keyProvider);
    }
}

