/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher;

import com.exceptionfactory.jagged.EncryptingChannelFactory;
import com.exceptionfactory.jagged.RecipientStanzaWriter;
import com.exceptionfactory.jagged.framework.armor.ArmoredEncryptingChannelFactory;
import com.exceptionfactory.jagged.framework.stream.StandardEncryptingChannelFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.cipher.DecryptContentAge;
import org.apache.nifi.processors.cipher.age.AgeKeyIndicator;
import org.apache.nifi.processors.cipher.age.AgeKeyReader;
import org.apache.nifi.processors.cipher.age.AgeKeyValidator;
import org.apache.nifi.processors.cipher.age.AgeProviderResolver;
import org.apache.nifi.processors.cipher.age.AgePublicKeyReader;
import org.apache.nifi.processors.cipher.age.FileEncoding;
import org.apache.nifi.processors.cipher.age.KeySource;
import org.apache.nifi.processors.cipher.io.ChannelStreamCallback;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"age", "age-encryption.org", "encryption", "ChaCha20-Poly1305", "X25519"})
@CapabilityDescription(value="Encrypt content using the age-encryption.org/v1 specification. Supports binary or ASCII armored content encoding using configurable properties. The age standard uses ChaCha20-Poly1305 for authenticated encryption of the payload. The age-keygen command supports generating X25519 key pairs for encryption and decryption operations.")
@SeeAlso(value={DecryptContentAge.class})
public class EncryptContentAge
extends AbstractProcessor
implements VerifiableProcessor {
    static final Relationship SUCCESS = new Relationship.Builder().name("success").description("Encryption Completed").build();
    static final Relationship FAILURE = new Relationship.Builder().name("failure").description("Encryption Failed").build();
    static final PropertyDescriptor FILE_ENCODING = new PropertyDescriptor.Builder().name("File Encoding").displayName("File Encoding").description("Output encoding for encrypted files. Binary encoding provides optimal processing performance.").required(true).defaultValue(FileEncoding.BINARY.getValue()).allowableValues(FileEncoding.class).build();
    static final PropertyDescriptor PUBLIC_KEY_SOURCE = new PropertyDescriptor.Builder().name("Public Key Source").displayName("Public Key Source").description("Source of information determines the loading strategy for X25519 Public Key Recipients").required(true).defaultValue(KeySource.PROPERTIES.getValue()).allowableValues(KeySource.class).build();
    static final PropertyDescriptor PUBLIC_KEY_RECIPIENTS = new PropertyDescriptor.Builder().name("Public Key Recipients").displayName("Public Key Recipients").description("One or more X25519 Public Key Recipients, separated with newlines, encoded according to the age specification, starting with age1").required(true).sensitive(true).addValidator((Validator)new AgeKeyValidator(AgeKeyIndicator.PUBLIC_KEY)).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.TEXT, new ResourceType[0]).dependsOn(PUBLIC_KEY_SOURCE, (DescribedValue)KeySource.PROPERTIES, new DescribedValue[0]).build();
    static final PropertyDescriptor PUBLIC_KEY_RECIPIENT_RESOURCES = new PropertyDescriptor.Builder().name("Public Key Recipient Resources").displayName("Public Key Recipient Resources").description("One or more files or URLs containing X25519 Public Key Recipients, separated with newlines, encoded according to the age specification, starting with age1").required(true).addValidator((Validator)new AgeKeyValidator(AgeKeyIndicator.PUBLIC_KEY)).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.URL}).dependsOn(PUBLIC_KEY_SOURCE, (DescribedValue)KeySource.RESOURCES, new DescribedValue[0]).build();
    private static final Set<Relationship> RELATIONSHIPS = new LinkedHashSet<Relationship>(Arrays.asList(SUCCESS, FAILURE));
    private static final List<PropertyDescriptor> DESCRIPTORS = Arrays.asList(FILE_ENCODING, PUBLIC_KEY_SOURCE, PUBLIC_KEY_RECIPIENTS, PUBLIC_KEY_RECIPIENT_RESOURCES);
    private static final Provider CIPHER_PROVIDER = AgeProviderResolver.getCipherProvider();
    private static final AgeKeyReader<RecipientStanzaWriter> PUBLIC_KEY_READER = new AgePublicKeyReader();
    private static final int BUFFER_CAPACITY = 65535;
    private static final String KEY_VERIFICATION_STEP = "Verify Public Key Recipients";
    private static final String NOT_FOUND_EXPLANATION = "Public Key Recipients not found";
    private volatile List<RecipientStanzaWriter> configuredRecipientStanzaWriters = Collections.emptyList();

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        ConfigVerificationResult.Builder verificationBuilder = new ConfigVerificationResult.Builder().verificationStepName(KEY_VERIFICATION_STEP);
        try {
            List<RecipientStanzaWriter> recipientStanzaWriters = this.getRecipientStanzaWriters((PropertyContext)context);
            if (recipientStanzaWriters.isEmpty()) {
                verificationLogger.warn(NOT_FOUND_EXPLANATION);
                verificationBuilder.outcome(ConfigVerificationResult.Outcome.FAILED).explanation(NOT_FOUND_EXPLANATION);
            } else {
                String explanation = String.format("Public Key Recipients found: %d", recipientStanzaWriters.size());
                verificationLogger.info(explanation);
                verificationBuilder.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation(explanation);
            }
        }
        catch (Exception e) {
            String explanation = String.format("Public Key Recipients not found: %s", e.getMessage());
            verificationLogger.warn(NOT_FOUND_EXPLANATION, (Throwable)e);
            verificationBuilder.outcome(ConfigVerificationResult.Outcome.FAILED).explanation(explanation);
        }
        results.add(verificationBuilder.build());
        return results;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        this.configuredRecipientStanzaWriters = this.getRecipientStanzaWriters((PropertyContext)context);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            String fileEncodingValue = context.getProperty(FILE_ENCODING).getValue();
            FileEncoding fileEncoding = FileEncoding.valueOf(fileEncodingValue);
            EncryptingChannelFactory encryptingChannelFactory = this.getEncryptingChannelFactory(fileEncoding);
            EncryptingStreamCallback streamCallback = new EncryptingStreamCallback(this.configuredRecipientStanzaWriters, encryptingChannelFactory);
            flowFile = session.write(flowFile, (StreamCallback)streamCallback);
            session.transfer(flowFile, SUCCESS);
        }
        catch (Exception e) {
            this.getLogger().error("Encryption Failed {}", new Object[]{flowFile, e});
            session.transfer(flowFile, FAILURE);
        }
    }

    private EncryptingChannelFactory getEncryptingChannelFactory(FileEncoding fileEncoding) {
        Object encryptingChannelFactory = FileEncoding.ASCII == fileEncoding ? new ArmoredEncryptingChannelFactory(CIPHER_PROVIDER) : new StandardEncryptingChannelFactory(CIPHER_PROVIDER);
        return encryptingChannelFactory;
    }

    private List<RecipientStanzaWriter> getRecipientStanzaWriters(PropertyContext context) throws IOException {
        KeySource keySource = KeySource.valueOf(context.getProperty(PUBLIC_KEY_SOURCE).getValue());
        ArrayList<ResourceReference> resources = new ArrayList<ResourceReference>();
        if (KeySource.PROPERTIES == keySource) {
            ResourceReference resource = context.getProperty(PUBLIC_KEY_RECIPIENTS).asResource();
            resources.add(resource);
        } else {
            ResourceReferences resourceReferences = context.getProperty(PUBLIC_KEY_RECIPIENT_RESOURCES).asResources();
            resources.addAll(resourceReferences.asList());
        }
        ArrayList<RecipientStanzaWriter> recipientStanzaWriters = new ArrayList<RecipientStanzaWriter>();
        for (ResourceReference resource : resources) {
            InputStream inputStream = resource.read();
            try {
                List<RecipientStanzaWriter> writers = PUBLIC_KEY_READER.read(inputStream);
                recipientStanzaWriters.addAll(writers);
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        if (recipientStanzaWriters.isEmpty()) {
            throw new IOException(NOT_FOUND_EXPLANATION);
        }
        return recipientStanzaWriters;
    }

    private static class EncryptingStreamCallback
    extends ChannelStreamCallback {
        private final List<RecipientStanzaWriter> recipientStanzaWriters;
        private final EncryptingChannelFactory encryptingChannelFactory;

        private EncryptingStreamCallback(List<RecipientStanzaWriter> recipientStanzaWriters, EncryptingChannelFactory encryptingChannelFactory) {
            super(65535);
            this.recipientStanzaWriters = recipientStanzaWriters;
            this.encryptingChannelFactory = encryptingChannelFactory;
        }

        @Override
        protected WritableByteChannel getWritableChannel(OutputStream outputStream) throws IOException {
            try {
                WritableByteChannel outputChannel = super.getWritableChannel(outputStream);
                return this.encryptingChannelFactory.newEncryptingChannel(outputChannel, this.recipientStanzaWriters);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Channel initialization failed", e);
            }
        }
    }
}

