/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.cdc.event.ColumnDefinition;
import org.apache.nifi.cdc.event.EventInfo;
import org.apache.nifi.cdc.mysql.event.MySQLCDCUtils;
import org.apache.nifi.cdc.mysql.event.UpdateRowsEventInfo;
import org.apache.nifi.cdc.mysql.event.io.AbstractBinlogTableEventWriter;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;

public class UpdateRowsWriter
extends AbstractBinlogTableEventWriter<UpdateRowsEventInfo> {
    @Override
    public long writeEvent(ProcessSession session, String transitUri, UpdateRowsEventInfo eventInfo, long currentSequenceId, Relationship relationship) {
        AtomicLong seqId = new AtomicLong(currentSequenceId);
        for (Map.Entry row : eventInfo.getRows()) {
            FlowFile flowFile = session.create();
            flowFile = session.write(flowFile, outputStream -> {
                super.startJson(outputStream, (EventInfo)eventInfo);
                super.writeJson(eventInfo);
                BitSet bitSet = eventInfo.getIncludedColumns();
                this.writeRow(eventInfo, row, bitSet);
                super.endJson();
            });
            flowFile = session.putAllAttributes(flowFile, this.getCommonAttributes(seqId.get(), eventInfo));
            session.transfer(flowFile, relationship);
            session.getProvenanceReporter().receive(flowFile, transitUri);
            seqId.getAndIncrement();
        }
        return seqId.get();
    }

    protected void writeRow(UpdateRowsEventInfo event, Map.Entry<Serializable[], Serializable[]> row, BitSet includedColumns) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("columns");
        int i = includedColumns.nextSetBit(0);
        while (i != -1) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeNumberField("id", i + 1);
            ColumnDefinition columnDefinition = event.getColumnByIndex(i);
            Integer columnType = null;
            if (columnDefinition != null) {
                this.jsonGenerator.writeStringField("name", columnDefinition.getName());
                columnType = columnDefinition.getType();
                this.jsonGenerator.writeNumberField("column_type", columnType.intValue());
            }
            Serializable[] oldRow = row.getKey();
            Serializable[] newRow = row.getValue();
            if (oldRow[i] == null) {
                this.jsonGenerator.writeNullField("last_value");
            } else {
                this.jsonGenerator.writeObjectField("last_value", MySQLCDCUtils.getWritableObject(columnType, oldRow[i]));
            }
            if (newRow[i] == null) {
                this.jsonGenerator.writeNullField("value");
            } else {
                this.jsonGenerator.writeObjectField("value", MySQLCDCUtils.getWritableObject(columnType, newRow[i]));
            }
            this.jsonGenerator.writeEndObject();
            i = includedColumns.nextSetBit(i + 1);
        }
        this.jsonGenerator.writeEndArray();
    }
}

