/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.processors.ssl;

import com.github.shyiko.mysql.binlog.network.SSLMode;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.nifi.cdc.mysql.processors.ssl.ConnectionPropertiesProvider;
import org.apache.nifi.cdc.mysql.processors.ssl.SecurityProperty;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsPlatform;

public class StandardConnectionPropertiesProvider
implements ConnectionPropertiesProvider {
    private static final String COMMA_SEPARATOR = ",";
    private final SSLMode sslMode;
    private final TlsConfiguration tlsConfiguration;

    public StandardConnectionPropertiesProvider(SSLMode sslMode, TlsConfiguration tlsConfiguration) {
        this.sslMode = Objects.requireNonNull(sslMode, "SSL Mode required");
        this.tlsConfiguration = tlsConfiguration;
    }

    @Override
    public Map<String, String> getConnectionProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        if (SSLMode.DISABLED == this.sslMode) {
            properties.put(SecurityProperty.USE_SSL.getProperty(), Boolean.FALSE.toString());
        } else {
            properties.put(SecurityProperty.USE_SSL.getProperty(), Boolean.TRUE.toString());
            if (SSLMode.PREFERRED == this.sslMode) {
                properties.put(SecurityProperty.REQUIRE_SSL.getProperty(), Boolean.FALSE.toString());
            } else {
                properties.put(SecurityProperty.REQUIRE_SSL.getProperty(), Boolean.TRUE.toString());
            }
            if (SSLMode.VERIFY_IDENTITY == this.sslMode) {
                properties.put(SecurityProperty.VERIFY_SERVER_CERTIFICATE.getProperty(), Boolean.TRUE.toString());
            }
            if (this.tlsConfiguration == null) {
                String protocols = TlsPlatform.getPreferredProtocols().stream().collect(Collectors.joining(COMMA_SEPARATOR));
                properties.put(SecurityProperty.ENABLED_TLS_PROTOCOLS.getProperty(), protocols);
            } else {
                Map<String, String> certificateProperties = this.getCertificateProperties();
                properties.putAll(certificateProperties);
            }
        }
        return properties;
    }

    private Map<String, String> getCertificateProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        String protocols = Arrays.stream(this.tlsConfiguration.getEnabledProtocols()).collect(Collectors.joining(COMMA_SEPARATOR));
        properties.put(SecurityProperty.ENABLED_TLS_PROTOCOLS.getProperty(), protocols);
        if (this.tlsConfiguration.isKeystorePopulated()) {
            properties.put(SecurityProperty.CLIENT_CERTIFICATE_KEY_STORE_URL.getProperty(), this.tlsConfiguration.getKeystorePath());
            properties.put(SecurityProperty.CLIENT_CERTIFICATE_KEY_STORE_TYPE.getProperty(), this.tlsConfiguration.getKeystoreType().getType());
            properties.put(SecurityProperty.CLIENT_CERTIFICATE_KEY_STORE_PASSWORD.getProperty(), this.tlsConfiguration.getKeystorePassword());
        }
        if (this.tlsConfiguration.isTruststorePopulated()) {
            properties.put(SecurityProperty.TRUST_CERTIFICATE_KEY_STORE_URL.getProperty(), this.tlsConfiguration.getTruststorePath());
            properties.put(SecurityProperty.TRUST_CERTIFICATE_KEY_STORE_TYPE.getProperty(), this.tlsConfiguration.getTruststoreType().getType());
            properties.put(SecurityProperty.TRUST_CERTIFICATE_KEY_STORE_PASSWORD.getProperty(), this.tlsConfiguration.getTruststorePassword());
        }
        return properties;
    }
}

