/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.event.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.cdc.event.io.FlowFileEventWriteStrategy;
import org.apache.nifi.flowfile.FlowFile;

public class EventWriterConfiguration {
    private final FlowFileEventWriteStrategy flowFileEventWriteStrategy;
    private final int numberOfEventsPerFlowFile;
    private int numberOfEventsWritten;
    private FlowFile currentFlowFile;
    private OutputStream flowFileOutputStream;
    private JsonGenerator jsonGenerator;

    public EventWriterConfiguration(FlowFileEventWriteStrategy flowFileEventWriteStrategy, int numberOfEventsPerFlowFile) {
        this.flowFileEventWriteStrategy = flowFileEventWriteStrategy;
        this.numberOfEventsPerFlowFile = numberOfEventsPerFlowFile;
    }

    public FlowFileEventWriteStrategy getFlowFileEventWriteStrategy() {
        return this.flowFileEventWriteStrategy;
    }

    public int getNumberOfEventsWritten() {
        return this.numberOfEventsWritten;
    }

    public void incrementNumberOfEventsWritten() {
        ++this.numberOfEventsWritten;
    }

    public void startNewFlowFile(FlowFile flowFile, OutputStream flowFileOutputStream, JsonGenerator jsonGenerator) {
        this.currentFlowFile = flowFile;
        this.flowFileOutputStream = flowFileOutputStream;
        this.jsonGenerator = jsonGenerator;
    }

    public void cleanUp() throws IOException {
        this.currentFlowFile = null;
        this.flowFileOutputStream.close();
        this.flowFileOutputStream = null;
        this.jsonGenerator = null;
        this.numberOfEventsWritten = 0;
    }

    public int getNumberOfEventsPerFlowFile() {
        return this.numberOfEventsPerFlowFile;
    }

    public FlowFile getCurrentFlowFile() {
        return this.currentFlowFile;
    }

    public OutputStream getFlowFileOutputStream() {
        return this.flowFileOutputStream;
    }

    public JsonGenerator getJsonGenerator() {
        return this.jsonGenerator;
    }
}

