/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import java.util.function.Function;
import org.apache.nifi.processors.box.BoxFileInfo;

public enum BoxFlowFileAttribute {
    ID("box.id", BoxFileInfo::getId),
    FILENAME("filename", BoxFileInfo::getName),
    PATH("path", BoxFileInfo::getPath),
    SIZE("box.size", fileInfo -> String.valueOf(fileInfo.getSize())),
    TIMESTAMP("box.timestamp", fileInfo -> String.valueOf(fileInfo.getTimestamp()));

    private final String name;
    private final Function<BoxFileInfo, String> fromFileInfo;

    private BoxFlowFileAttribute(String attributeName, Function<BoxFileInfo, String> fromFileInfo) {
        this.name = attributeName;
        this.fromFileInfo = fromFileInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getValue(BoxFileInfo fileInfo) {
        return this.fromFileInfo.apply(fileInfo);
    }
}

