/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.util.mapr.MapRComponentsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapRLibsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapRLibsUtil.class);
    public static final String DEFAULT_MAPR_LIBS = "/opt/mapr/lib";
    public static final String ALL_DEPENDENCIES = "*";
    private static final List<String> MAPR_LIBS_PREFIXES = Arrays.asList("hadoop-common", "hadoop-yarn-api", "hadoop-auth", "zookeeper");
    private static final List<String> JARS_EXCEPTIONS = Arrays.asList("jetty", "jersey", "jsr311-api", "jsp-api", "avro", "asm", "slf4j-reload4j");

    public static List<File> getMapRLibs(String libPath) throws IOException {
        Path maprLibs = Paths.get(libPath, new String[0]);
        if (!Files.exists(maprLibs, new LinkOption[0])) {
            throw new FileNotFoundException("MapR lib folder does not exist at " + libPath);
        }
        ArrayList<File> jarLibs = new ArrayList<File>(MapRLibsUtil.getJarsFromFolder(MAPR_LIBS_PREFIXES, maprLibs));
        Path maprHome = maprLibs.getParent();
        jarLibs.addAll(MapRLibsUtil.getSpecificHadoopJars(maprHome));
        jarLibs.addAll(MapRLibsUtil.getSpecificHBaseJars(maprHome));
        jarLibs.addAll(MapRLibsUtil.getSpecificHiveJars(maprHome));
        return jarLibs;
    }

    private static List<File> getSpecificHadoopJars(Path homePath) throws IOException {
        String component = "hadoop";
        Path hadoopFolder = MapRComponentsUtils.getComponentFolder((String)component, (String)homePath.toString());
        Path hdfsFolder = Paths.get(hadoopFolder.toString(), "share/hadoop/hdfs");
        ArrayList<File> hadoopLibs = new ArrayList<File>(MapRLibsUtil.getJarsFromFolder("hadoop-hdfs", hdfsFolder));
        Path mapreduceFolder = Paths.get(hadoopFolder.toString(), "share/hadoop/mapreduce");
        hadoopLibs.addAll(MapRLibsUtil.getJarsFromFolder("hadoop-mapreduce-client-core", mapreduceFolder));
        Path hadoopCommonLibsFolder = Paths.get(hadoopFolder.toString(), "share/hadoop/common/lib/");
        hadoopLibs.addAll(MapRLibsUtil.getJarsFromFolder(ALL_DEPENDENCIES, hadoopCommonLibsFolder));
        return hadoopLibs;
    }

    private static List<File> getSpecificHBaseJars(Path homePath) {
        String component = "hbase";
        try {
            Path hbaseFolder = MapRComponentsUtils.getComponentFolder((String)component, (String)homePath.toString());
            Path hbaseLibFolder = Paths.get(hbaseFolder.toString(), "/lib");
            List<String> hbaseLibsList = List.of("hbase-", "netty-", "metrics-");
            return MapRLibsUtil.getJarsFromFolder(hbaseLibsList, hbaseLibFolder);
        }
        catch (IOException e) {
            LOGGER.warn("Hbase not installed error: {}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    private static List<File> getSpecificHiveJars(Path homePath) {
        String component = "hive";
        try {
            Path hiveFolder = MapRComponentsUtils.getComponentFolder((String)component, (String)homePath.toString());
            Path hiveLibFolder = Paths.get(hiveFolder.toString(), "/lib");
            List<String> hiveLibsList = List.of("hive-jdbc", "hive-exec", "hive-streaming", "hive-hcatalog-core", "hive-service", "hive-maprdb", "antlr", "libfb303", "mapr-util");
            return MapRLibsUtil.getJarsFromFolder(hiveLibsList, hiveLibFolder);
        }
        catch (IOException e) {
            LOGGER.warn("Hive not installed error: {}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    private static List<File> getJarsFromFolder(String prefix, Path path) {
        return MapRLibsUtil.getJarsFromFolder(Collections.singletonList(prefix), path);
    }

    private static List<File> getJarsFromFolder(List<String> prefixes, Path path) {
        try {
            return Files.list(path).filter(file -> MapRLibsUtil.jarFilter(prefixes, file)).map(Path::toFile).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOGGER.error("Failed to access {} error: {}", (Object)path, (Object)e);
            return Collections.emptyList();
        }
    }

    private static boolean jarFilter(List<String> prefixes, Path file) {
        boolean isSuffixCorrect;
        String fileName = file.getFileName().toString().toLowerCase();
        boolean containsJarsExceptions = JARS_EXCEPTIONS.stream().anyMatch(fileName::startsWith);
        if (containsJarsExceptions) {
            return false;
        }
        boolean bl = isSuffixCorrect = fileName.endsWith(".jar") && !fileName.endsWith("-tests.jar");
        if (!prefixes.contains(ALL_DEPENDENCIES)) {
            return prefixes.stream().anyMatch(fileName::startsWith) && isSuffixCorrect;
        }
        return isSuffixCorrect;
    }
}

