/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.util;

import java.io.IOException;
import java.io.InputStream;

public class LimitingInputStream
extends InputStream {
    private final InputStream in;
    private final long limit;
    private long bytesRead = 0L;

    public LimitingInputStream(InputStream in, long limit) {
        this.in = in;
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRead >= this.limit) {
            return -1;
        }
        int val = this.in.read();
        if (val > -1) {
            ++this.bytesRead;
        }
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.bytesRead >= this.limit) {
            return -1;
        }
        int maxToRead = (int)Math.min((long)b.length, this.limit - this.bytesRead);
        int val = this.in.read(b, 0, maxToRead);
        if (val > 0) {
            this.bytesRead += (long)val;
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesRead >= this.limit) {
            return -1;
        }
        int maxToRead = (int)Math.min((long)len, this.limit - this.bytesRead);
        int val = this.in.read(b, off, maxToRead);
        if (val > 0) {
            this.bytesRead += (long)val;
        }
        return val;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(Math.min(n, this.limit - this.bytesRead));
        this.bytesRead += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }
}

