/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.bin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.FragmentAttributes;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.bin.EvictionReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bin {
    private static final Logger logger = LoggerFactory.getLogger(Bin.class);
    public static final String FRAGMENT_INDEX_ATTRIBUTE = FragmentAttributes.FRAGMENT_INDEX.key();
    private final ProcessSession session;
    private final long creationMomentEpochNs;
    private final long minimumSizeBytes;
    private final long maximumSizeBytes;
    private volatile int minimumEntries;
    private volatile int maximumEntries;
    private final String fileCountAttribute;
    private volatile EvictionReason evictionReason = EvictionReason.UNSET;
    private final List<FlowFile> binContents = new ArrayList<FlowFile>();
    private final Set<String> binIndexSet = new HashSet<String>();
    private long size;
    private int successiveFailedOfferings = 0;
    private static final Pattern intPattern = Pattern.compile("\\d+");

    public Bin(ProcessSession session, long minSizeBytes, long maxSizeBytes, int minEntries, int maxEntries, String fileCountAttribute) {
        this.session = session;
        this.fileCountAttribute = fileCountAttribute;
        if (this.fileCountAttribute != null) {
            this.minimumSizeBytes = 0L;
            this.maximumSizeBytes = Long.MAX_VALUE;
            this.minimumEntries = Integer.MAX_VALUE;
            this.maximumEntries = Integer.MAX_VALUE;
        } else {
            this.minimumSizeBytes = minSizeBytes;
            this.maximumSizeBytes = maxSizeBytes;
            this.minimumEntries = minEntries;
            this.maximumEntries = maxEntries;
        }
        this.creationMomentEpochNs = System.nanoTime();
        if (minSizeBytes > maxSizeBytes) {
            throw new IllegalArgumentException();
        }
    }

    public ProcessSession getSession() {
        return this.session;
    }

    public boolean isFull() {
        return this.size >= this.minimumSizeBytes && this.binContents.size() >= this.minimumEntries && this.successiveFailedOfferings > 5 || this.size >= this.maximumSizeBytes || this.binContents.size() >= this.maximumEntries;
    }

    public EvictionReason determineFullness() {
        if (this.size >= this.maximumSizeBytes) {
            return EvictionReason.MAX_BYTES_THRESHOLD_REACHED;
        }
        if (this.binContents.size() >= this.maximumEntries) {
            return EvictionReason.MAX_ENTRIES_THRESHOLD_REACHED;
        }
        if (this.size >= this.minimumSizeBytes && this.binContents.size() >= this.minimumEntries) {
            return EvictionReason.MIN_THRESHOLDS_REACHED;
        }
        return null;
    }

    public boolean isFullEnough() {
        return this.isFull() || this.size >= this.minimumSizeBytes && this.binContents.size() >= this.minimumEntries;
    }

    public boolean isOlderThan(int duration, TimeUnit unit) {
        long ageInNanos = System.nanoTime() - this.creationMomentEpochNs;
        return ageInNanos > TimeUnit.NANOSECONDS.convert(duration, unit);
    }

    public boolean isOlderThan(Bin other) {
        return this.creationMomentEpochNs < other.creationMomentEpochNs;
    }

    public EvictionReason getEvictionReason() {
        return this.evictionReason;
    }

    public void setEvictionReason(EvictionReason evictionReason) {
        this.evictionReason = evictionReason;
    }

    public boolean offer(FlowFile flowFile, ProcessSession session) {
        if (this.size + flowFile.getSize() > this.maximumSizeBytes || this.binContents.size() >= this.maximumEntries) {
            ++this.successiveFailedOfferings;
            return false;
        }
        if (this.fileCountAttribute != null) {
            String index;
            String countValue = flowFile.getAttribute(this.fileCountAttribute);
            Integer count = this.toInteger(countValue);
            if (count != null) {
                this.maximumEntries = count;
                this.minimumEntries = count;
            }
            if ((index = flowFile.getAttribute(FRAGMENT_INDEX_ATTRIBUTE)) == null || index.isEmpty() || !this.binIndexSet.add(index)) {
                logger.warn("Duplicate or missing value for '" + FRAGMENT_INDEX_ATTRIBUTE + "' in defragment mode. Flowfile {} not allowed in Bin", (Object)flowFile);
                ++this.successiveFailedOfferings;
                return false;
            }
        }
        this.size += flowFile.getSize();
        session.migrate(this.getSession(), Collections.singleton(flowFile));
        this.binContents.add(flowFile);
        this.successiveFailedOfferings = 0;
        return true;
    }

    public Integer toInteger(String value) {
        if (value == null) {
            return null;
        }
        if (!intPattern.matcher(value).matches()) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<FlowFile> getContents() {
        return this.binContents;
    }

    public long getBinAge() {
        long ageInNanos = System.nanoTime() - this.creationMomentEpochNs;
        return TimeUnit.MILLISECONDS.convert(ageInNanos, TimeUnit.NANOSECONDS);
    }
}

