/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import com.azure.core.credential.AccessToken;
import com.azure.core.http.ProxyOptions;
import java.util.Objects;
import org.apache.nifi.services.azure.util.ProxyOptionsUtils;

public class ADLSCredentialsDetails {
    private final String accountName;
    private final String accountKey;
    private final String sasToken;
    private final String endpointSuffix;
    private final AccessToken accessToken;
    private final boolean useManagedIdentity;
    private final String managedIdentityClientId;
    private final String servicePrincipalTenantId;
    private final String servicePrincipalClientId;
    private final String servicePrincipalClientSecret;
    private final ProxyOptions proxyOptions;

    public ADLSCredentialsDetails(String accountName, String accountKey, String sasToken, String endpointSuffix, AccessToken accessToken, boolean useManagedIdentity, String managedIdentityClientId, String servicePrincipalTenantId, String servicePrincipalClientId, String servicePrincipalClientSecret, ProxyOptions proxyOptions) {
        this.accountName = accountName;
        this.accountKey = accountKey;
        this.sasToken = sasToken;
        this.endpointSuffix = endpointSuffix;
        this.accessToken = accessToken;
        this.useManagedIdentity = useManagedIdentity;
        this.managedIdentityClientId = managedIdentityClientId;
        this.servicePrincipalTenantId = servicePrincipalTenantId;
        this.servicePrincipalClientId = servicePrincipalClientId;
        this.servicePrincipalClientSecret = servicePrincipalClientSecret;
        this.proxyOptions = proxyOptions;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getEndpointSuffix() {
        return this.endpointSuffix;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public String getSasToken() {
        return this.sasToken;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public boolean getUseManagedIdentity() {
        return this.useManagedIdentity;
    }

    public String getManagedIdentityClientId() {
        return this.managedIdentityClientId;
    }

    public String getServicePrincipalTenantId() {
        return this.servicePrincipalTenantId;
    }

    public String getServicePrincipalClientId() {
        return this.servicePrincipalClientId;
    }

    public String getServicePrincipalClientSecret() {
        return this.servicePrincipalClientSecret;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ADLSCredentialsDetails that = (ADLSCredentialsDetails)o;
        return this.useManagedIdentity == that.useManagedIdentity && Objects.equals(this.accountName, that.accountName) && Objects.equals(this.accountKey, that.accountKey) && Objects.equals(this.sasToken, that.sasToken) && Objects.equals(this.endpointSuffix, that.endpointSuffix) && Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.managedIdentityClientId, that.managedIdentityClientId) && Objects.equals(this.servicePrincipalTenantId, that.servicePrincipalTenantId) && Objects.equals(this.servicePrincipalClientId, that.servicePrincipalClientId) && Objects.equals(this.servicePrincipalClientSecret, that.servicePrincipalClientSecret) && ProxyOptionsUtils.equalsProxyOptions(this.proxyOptions, that.proxyOptions);
    }

    public int hashCode() {
        return Objects.hash(this.accountName, this.accountKey, this.sasToken, this.endpointSuffix, this.accessToken, this.useManagedIdentity, this.managedIdentityClientId, this.servicePrincipalTenantId, this.servicePrincipalClientId, this.servicePrincipalClientSecret, ProxyOptionsUtils.hashCodeProxyOptions(this.proxyOptions));
    }

    public static class Builder {
        private String accountName;
        private String accountKey;
        private String sasToken;
        private String endpointSuffix;
        private AccessToken accessToken;
        private boolean useManagedIdentity;
        private String managedIdentityClientId;
        private String servicePrincipalTenantId;
        private String servicePrincipalClientId;
        private String servicePrincipalClientSecret;
        private ProxyOptions proxyOptions;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder setAccountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public Builder setAccountKey(String accountKey) {
            this.accountKey = accountKey;
            return this;
        }

        public Builder setSasToken(String sasToken) {
            this.sasToken = sasToken;
            return this;
        }

        public Builder setEndpointSuffix(String endpointSuffix) {
            this.endpointSuffix = endpointSuffix;
            return this;
        }

        public Builder setAccessToken(AccessToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder setUseManagedIdentity(boolean useManagedIdentity) {
            this.useManagedIdentity = useManagedIdentity;
            return this;
        }

        public Builder setManagedIdentityClientId(String useManagedIdentityClientId) {
            this.managedIdentityClientId = useManagedIdentityClientId;
            return this;
        }

        public Builder setServicePrincipalTenantId(String servicePrincipalTenantId) {
            this.servicePrincipalTenantId = servicePrincipalTenantId;
            return this;
        }

        public Builder setServicePrincipalClientId(String servicePrincipalClientId) {
            this.servicePrincipalClientId = servicePrincipalClientId;
            return this;
        }

        public Builder setServicePrincipalClientSecret(String servicePrincipalClientSecret) {
            this.servicePrincipalClientSecret = servicePrincipalClientSecret;
            return this;
        }

        public Builder setProxyOptions(ProxyOptions proxyOptions) {
            this.proxyOptions = proxyOptions;
            return this;
        }

        public ADLSCredentialsDetails build() {
            return new ADLSCredentialsDetails(this.accountName, this.accountKey, this.sasToken, this.endpointSuffix, this.accessToken, this.useManagedIdentity, this.managedIdentityClientId, this.servicePrincipalTenantId, this.servicePrincipalClientId, this.servicePrincipalClientSecret, this.proxyOptions);
        }
    }
}

