/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import org.apache.nifi.components.AllowableValue;

public enum AzureStorageCredentialsType {
    ACCOUNT_KEY("Account Key", "The primary or secondary Account Key of the storage account that provides full access to the resources in the account"),
    SAS_TOKEN("SAS Token", "SAS (Shared Access Signature) Token generated for accessing resources in the storage account"),
    MANAGED_IDENTITY("Managed Identity", "Azure Virtual Machine Managed Identity (it can only be used when NiFi is running on Azure)"),
    SERVICE_PRINCIPAL("Service Principal", "Azure Active Directory Service Principal with Client Id / Client Secret of a registered application"),
    ACCESS_TOKEN("Access Token", "Access Token provided by custom controller service implementations");

    private final String label;
    private final String description;

    private AzureStorageCredentialsType(String label, String description) {
        this.label = label;
        this.description = description;
    }

    public AllowableValue getAllowableValue() {
        return new AllowableValue(this.name(), this.label, this.description);
    }
}

