/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.azure.loganalytics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.methods.HttpPost;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.azure.loganalytics.AbstractAzureLogAnalyticsReportingTask;
import org.apache.nifi.reporting.azure.loganalytics.Metric;
import org.apache.nifi.reporting.azure.loganalytics.api.AzureLogAnalyticsMetricsFactory;
import org.apache.nifi.scheduling.SchedulingStrategy;

@Tags(value={"azure", "metrics", "reporting", "log analytics"})
@CapabilityDescription(value="Sends JVM-metrics as well as Apache NiFi-metrics to a Azure Log Analytics workspace.Apache NiFi-metrics can be either configured global or on process-group level.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class AzureLogAnalyticsReportingTask
extends AbstractAzureLogAnalyticsReportingTask {
    private static final String JVM_JOB_NAME = "jvm_global";
    private final JvmMetrics virtualMachineMetrics = JmxJvmMetrics.getInstance();
    static final PropertyDescriptor SEND_JVM_METRICS = new PropertyDescriptor.Builder().name("Send JVM Metrics").description("Send JVM Metrics in addition to the NiFi-metrics").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    static final PropertyDescriptor LOG_ANALYTICS_CUSTOM_LOG_NAME = new PropertyDescriptor.Builder().name("Log Analytics Custom Log Name").description("Log Analytics Custom Log Name").required(false).defaultValue("nifimetrics").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(SEND_JVM_METRICS);
        properties.add(LOG_ANALYTICS_WORKSPACE_ID);
        properties.add(LOG_ANALYTICS_CUSTOM_LOG_NAME);
        properties.add(LOG_ANALYTICS_WORKSPACE_KEY);
        properties.add(APPLICATION_ID);
        properties.add(INSTANCE_ID);
        properties.add(PROCESS_GROUP_IDS);
        properties.add(JOB_NAME);
        properties.add(LOG_ANALYTICS_URL_ENDPOINT_FORMAT);
        return properties;
    }

    public void onTrigger(ReportingContext context) {
        String workspaceId = context.getProperty(LOG_ANALYTICS_WORKSPACE_ID).evaluateAttributeExpressions().getValue();
        String linuxPrimaryKey = context.getProperty(LOG_ANALYTICS_WORKSPACE_KEY).evaluateAttributeExpressions().getValue();
        boolean jvmMetricsCollected = context.getProperty(SEND_JVM_METRICS).asBoolean();
        String logName = context.getProperty(LOG_ANALYTICS_CUSTOM_LOG_NAME).evaluateAttributeExpressions().getValue();
        String instanceId = context.getProperty(INSTANCE_ID).evaluateAttributeExpressions().getValue();
        String groupIds = context.getProperty(PROCESS_GROUP_IDS).evaluateAttributeExpressions().getValue();
        String urlEndpointFormat = context.getProperty(LOG_ANALYTICS_URL_ENDPOINT_FORMAT).evaluateAttributeExpressions().getValue();
        try {
            ArrayList<Metric> allMetrics = null;
            if (groupIds == null || groupIds.isEmpty()) {
                String[] status = context.getEventAccess().getControllerStatus();
                String processGroupName = status.getName();
                allMetrics = this.collectMetrics(instanceId, (ProcessGroupStatus)status, processGroupName, jvmMetricsCollected);
            } else {
                allMetrics = new ArrayList();
                for (String groupId : groupIds.split(",")) {
                    groupId = groupId.trim();
                    ProcessGroupStatus status = context.getEventAccess().getGroupStatus(groupId);
                    String processGroupName = status.getName();
                    allMetrics.addAll(this.collectMetrics(instanceId, status, processGroupName, jvmMetricsCollected));
                }
            }
            HttpPost httpPost = this.getHttpPost(urlEndpointFormat, workspaceId, logName);
            this.sendMetrics(httpPost, workspaceId, linuxPrimaryKey, allMetrics);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to publish metrics to Azure Log Analytics", (Throwable)e);
        }
    }

    protected void sendMetrics(HttpPost request, String workspaceId, String linuxPrimaryKey, List<Metric> allMetrics) throws IOException, IllegalArgumentException, RuntimeException {
        Gson gson = new GsonBuilder().create();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (Metric current : allMetrics) {
            builder.append(gson.toJson((Object)current));
            builder.append(',');
        }
        builder.append(']');
        this.sendToLogAnalytics(request, workspaceId, linuxPrimaryKey, builder.toString());
    }

    protected List<Metric> collectMetrics(String instanceId, ProcessGroupStatus status, String processGroupName, boolean jvmMetricsCollected) {
        ArrayList<Metric> allMetrics = new ArrayList<Metric>();
        allMetrics.addAll(AzureLogAnalyticsMetricsFactory.getDataFlowMetrics(status, instanceId));
        ArrayList<ConnectionStatus> connectionStatuses = new ArrayList<ConnectionStatus>();
        this.populateConnectionStatuses(status, connectionStatuses);
        for (ConnectionStatus connectionStatus : connectionStatuses) {
            allMetrics.addAll(AzureLogAnalyticsMetricsFactory.getConnectionStatusMetrics(connectionStatus, instanceId, processGroupName));
        }
        ArrayList<ProcessorStatus> processorStatuses = new ArrayList<ProcessorStatus>();
        this.populateProcessorStatuses(status, processorStatuses);
        for (ProcessorStatus processorStatus : processorStatuses) {
            allMetrics.addAll(AzureLogAnalyticsMetricsFactory.getProcessorMetrics(processorStatus, instanceId, processGroupName));
        }
        if (jvmMetricsCollected) {
            allMetrics.addAll(AzureLogAnalyticsMetricsFactory.getJvmMetrics(this.virtualMachineMetrics, instanceId, JVM_JOB_NAME));
        }
        return allMetrics;
    }

    private void populateProcessorStatuses(ProcessGroupStatus groupStatus, List<ProcessorStatus> statuses) {
        statuses.addAll(groupStatus.getProcessorStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateProcessorStatuses(childGroupStatus, statuses);
        }
    }

    private void populateConnectionStatuses(ProcessGroupStatus groupStatus, List<ConnectionStatus> statuses) {
        statuses.addAll(groupStatus.getConnectionStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateConnectionStatuses(childGroupStatus, statuses);
        }
    }
}

