/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import java.util.Map;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.service.lookup.AbstractSingleAttributeBasedControllerServiceLookup;
import org.apache.nifi.services.azure.storage.ADLSCredentialsDetails;
import org.apache.nifi.services.azure.storage.ADLSCredentialsService;

@Tags(value={"azure", "microsoft", "cloud", "storage", "adls", "credentials"})
@CapabilityDescription(value="Provides an ADLSCredentialsService that can be used to dynamically select another ADLSCredentialsService. This service requires an attribute named 'adls.credentials.name' to be passed in, and will throw an exception if the attribute is missing. The value of 'adls.credentials.name' will be used to select the ADLSCredentialsService that has been registered with that name. This will allow multiple ADLSCredentialsServices to be defined and registered, and then selected dynamically at runtime by tagging flow files with the appropriate 'adls.credentials.name' attribute.")
@DynamicProperty(name="The name to register ADLSCredentialsService", value="The ADLSCredentialsService", description="If 'adls.credentials.name' attribute contains the name of the dynamic property, then the ADLSCredentialsService (registered in the value) will be selected.", expressionLanguageScope=ExpressionLanguageScope.NONE)
public class ADLSCredentialsControllerServiceLookup
extends AbstractSingleAttributeBasedControllerServiceLookup<ADLSCredentialsService>
implements ADLSCredentialsService {
    public static final String ADLS_CREDENTIALS_NAME_ATTRIBUTE = "adls.credentials.name";

    protected String getLookupAttribute() {
        return ADLS_CREDENTIALS_NAME_ATTRIBUTE;
    }

    public Class<ADLSCredentialsService> getServiceType() {
        return ADLSCredentialsService.class;
    }

    public ADLSCredentialsDetails getCredentialsDetails(Map<String, String> attributes) {
        return ((ADLSCredentialsService)this.lookupService(attributes)).getCredentialsDetails(attributes);
    }
}

