/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure;

import com.azure.storage.file.datalake.DataLakeServiceClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.processors.azure.storage.utils.DataLakeServiceClientFactory;
import org.apache.nifi.services.azure.storage.ADLSCredentialsDetails;
import org.apache.nifi.services.azure.storage.ADLSCredentialsService;

public abstract class AbstractAzureDataLakeStorageProcessor
extends AbstractProcessor {
    public static final PropertyDescriptor ADLS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("adls-credentials-service").displayName("ADLS Credentials").description("Controller Service used to obtain Azure Credentials.").identifiesControllerService(ADLSCredentialsService.class).required(true).build();
    public static final PropertyDescriptor FILESYSTEM = new PropertyDescriptor.Builder().name("filesystem-name").displayName("Filesystem Name").description("Name of the Azure Storage File System (also called Container). It is assumed to be already existing.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor DIRECTORY = new PropertyDescriptor.Builder().name("directory-name").displayName("Directory Name").description("Name of the Azure Storage Directory. The Directory Name cannot contain a leading '/'. The root directory can be designated by the empty string value. In case of the PutAzureDataLakeStorage processor, the directory will be created if not already existing.").addValidator((Validator)new DirectoryValidator()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor FILE = new PropertyDescriptor.Builder().name("file-name").displayName("File Name").description("The filename").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).defaultValue(String.format("${%s}", "azure.filename")).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Files that have been successfully written to Azure storage are transferred to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Files that could not be written to Azure storage for some reason are transferred to this relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    public static final String TEMP_FILE_DIRECTORY = "_nifitempdirectory";
    private volatile DataLakeServiceClientFactory clientFactory;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.clientFactory = new DataLakeServiceClientFactory(this.getLogger(), AzureStorageUtils.getProxyOptions((PropertyContext)context));
    }

    @OnStopped
    public void onStopped() {
        this.clientFactory = null;
    }

    public DataLakeServiceClient getStorageClient(PropertyContext context, FlowFile flowFile) {
        Map attributes = flowFile != null ? flowFile.getAttributes() : Collections.emptyMap();
        ADLSCredentialsService credentialsService = (ADLSCredentialsService)context.getProperty(ADLS_CREDENTIALS_SERVICE).asControllerService(ADLSCredentialsService.class);
        ADLSCredentialsDetails credentialsDetails = credentialsService.getCredentialsDetails(attributes);
        DataLakeServiceClient storageClient = (DataLakeServiceClient)this.clientFactory.getStorageClient(credentialsDetails);
        return storageClient;
    }

    public static String evaluateFileSystemProperty(ProcessContext context, FlowFile flowFile) {
        return AbstractAzureDataLakeStorageProcessor.evaluateFileSystemProperty(context, flowFile, FILESYSTEM);
    }

    public static String evaluateFileSystemProperty(ProcessContext context, FlowFile flowFile, PropertyDescriptor property) {
        String fileSystem = context.getProperty(property).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isBlank((CharSequence)fileSystem)) {
            throw new ProcessException(String.format("'%1$s' property evaluated to blank string. '%s' must be specified as a non-blank string.", property.getDisplayName()));
        }
        return fileSystem;
    }

    public static String evaluateDirectoryProperty(ProcessContext context, FlowFile flowFile) {
        return AbstractAzureDataLakeStorageProcessor.evaluateDirectoryProperty(context, flowFile, DIRECTORY);
    }

    public static String evaluateDirectoryProperty(ProcessContext context, FlowFile flowFile, PropertyDescriptor property) {
        String directory = context.getProperty(property).evaluateAttributeExpressions(flowFile).getValue();
        if (directory.startsWith("/")) {
            throw new ProcessException(String.format("'%1$s' starts with '/'. '%s' cannot contain a leading '/'.", property.getDisplayName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)directory) && StringUtils.isWhitespace((CharSequence)directory)) {
            throw new ProcessException(String.format("'%1$s' contains whitespace characters only.", property.getDisplayName()));
        }
        return directory;
    }

    public static String evaluateFileNameProperty(ProcessContext context, FlowFile flowFile) {
        String fileName = context.getProperty(FILE).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new ProcessException(String.format("'%1$s' property evaluated to blank string. '%s' must be specified as a non-blank string.", FILE.getDisplayName()));
        }
        return fileName;
    }

    public static class DirectoryValidator
    implements Validator {
        private String displayName;

        public DirectoryValidator() {
            this.displayName = null;
        }

        public DirectoryValidator(String displayName) {
            this.displayName = displayName;
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            this.displayName = this.displayName == null ? DIRECTORY.getDisplayName() : this.displayName;
            ValidationResult.Builder builder = new ValidationResult.Builder().subject(this.displayName).input(input);
            if (context.isExpressionLanguagePresent(input)) {
                builder.valid(true).explanation("Expression Language Present");
            } else if (input.startsWith("/")) {
                builder.valid(false).explanation(String.format("'%s' cannot contain a leading '/'", this.displayName));
            } else if (StringUtils.isNotEmpty((CharSequence)input) && StringUtils.isWhitespace((CharSequence)input)) {
                builder.valid(false).explanation(String.format("'%s' cannot contain whitespace characters only", this.displayName));
            } else {
                builder.valid(true);
            }
            return builder.build();
        }
    }
}

