/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsService;
import org.apache.nifi.services.azure.storage.AzureStorageEmulatorCredentialsDetails;

@Tags(value={"azure", "microsoft", "emulator", "storage", "blob", "queue", "credentials"})
@CapabilityDescription(value="Defines credentials for Azure Storage processors that connects to Azurite emulator.")
public class AzureStorageEmulatorCredentialsControllerService
extends AbstractControllerService
implements AzureStorageCredentialsService {
    public static final PropertyDescriptor DEVELOPMENT_STORAGE_PROXY_URI = new PropertyDescriptor.Builder().name("azurite-uri").displayName("Storage Emulator URI").description("URI to connect to Azure Storage Emulator (Azurite)").required(false).sensitive(false).addValidator(StandardValidators.URI_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(DEVELOPMENT_STORAGE_PROXY_URI));
    private String azuriteProxyUri;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        return results;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.azuriteProxyUri = context.getProperty(DEVELOPMENT_STORAGE_PROXY_URI).getValue();
    }

    public String getProxyUri() {
        return this.azuriteProxyUri;
    }

    public AzureStorageCredentialsDetails getStorageCredentialsDetails(Map<String, String> attributes) {
        return new AzureStorageEmulatorCredentialsDetails(this.azuriteProxyUri);
    }
}

