/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.AbstractAzureDataLakeStorageProcessor;
import org.apache.nifi.processors.azure.storage.DeleteAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.FetchAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.ListAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;

@Tags(value={"azure", "microsoft", "cloud", "storage", "adlsgen2", "datalake"})
@SeeAlso(value={DeleteAzureDataLakeStorage.class, FetchAzureDataLakeStorage.class, ListAzureDataLakeStorage.class})
@CapabilityDescription(value="Moves content within an Azure Data Lake Storage Gen 2. After the move, files will be no longer available on source location.")
@WritesAttributes(value={@WritesAttribute(attribute="azure.source.filesystem", description="The name of the source Azure File System"), @WritesAttribute(attribute="azure.source.directory", description="The name of the source Azure Directory"), @WritesAttribute(attribute="azure.filesystem", description="The name of the Azure File System"), @WritesAttribute(attribute="azure.directory", description="The name of the Azure Directory"), @WritesAttribute(attribute="azure.filename", description="The name of the Azure File"), @WritesAttribute(attribute="azure.primaryUri", description="Primary location for file content"), @WritesAttribute(attribute="azure.length", description="The length of the Azure File")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class MoveAzureDataLakeStorage
extends AbstractAzureDataLakeStorageProcessor {
    public static final String FAIL_RESOLUTION = "fail";
    public static final String REPLACE_RESOLUTION = "replace";
    public static final String IGNORE_RESOLUTION = "ignore";
    public static final PropertyDescriptor CONFLICT_RESOLUTION = new PropertyDescriptor.Builder().name("conflict-resolution-strategy").displayName("Conflict Resolution Strategy").description("Indicates what should happen when a file with the same name already exists in the output directory").required(true).defaultValue("fail").allowableValues(new String[]{"fail", "replace", "ignore"}).build();
    public static final PropertyDescriptor SOURCE_FILESYSTEM = new PropertyDescriptor.Builder().name("source-filesystem-name").displayName("Source Filesystem").description("Name of the Azure Storage File System from where the move should happen.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).defaultValue(String.format("${%s}", "azure.filesystem")).build();
    public static final PropertyDescriptor SOURCE_DIRECTORY = new PropertyDescriptor.Builder().name("source-directory-name").displayName("Source Directory").description("Name of the Azure Storage Directory from where the move should happen. The Directory Name cannot contain a leading '/'. The root directory can be designated by the empty string value.").addValidator((Validator)new AbstractAzureDataLakeStorageProcessor.DirectoryValidator("Source Directory")).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).defaultValue(String.format("${%s}", "azure.directory")).build();
    public static final PropertyDescriptor DESTINATION_FILESYSTEM = new PropertyDescriptor.Builder().fromPropertyDescriptor(FILESYSTEM).displayName("Destination Filesystem").description("Name of the Azure Storage File System where the files will be moved.").build();
    public static final PropertyDescriptor DESTINATION_DIRECTORY = new PropertyDescriptor.Builder().fromPropertyDescriptor(DIRECTORY).displayName("Destination Directory").description("Name of the Azure Storage Directory where the files will be moved. The Directory Name cannot contain a leading '/'. The root directory can be designated by the empty string value. Non-existing directories will be created. If the original directory structure should be kept, the full directory path needs to be provided after the destination directory. e.g.: destdir/${azure.directory}").addValidator((Validator)new AbstractAzureDataLakeStorageProcessor.DirectoryValidator("Destination Directory")).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(ADLS_CREDENTIALS_SERVICE, SOURCE_FILESYSTEM, SOURCE_DIRECTORY, DESTINATION_FILESYSTEM, DESTINATION_DIRECTORY, FILE, CONFLICT_RESOLUTION, AzureStorageUtils.PROXY_CONFIGURATION_SERVICE));

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        block8: {
            FlowFile flowFile = session.get();
            if (flowFile == null) {
                return;
            }
            long startNanos = System.nanoTime();
            try {
                String sourceFileSystem = MoveAzureDataLakeStorage.evaluateFileSystemProperty(context, flowFile, SOURCE_FILESYSTEM);
                String sourceDirectory = MoveAzureDataLakeStorage.evaluateDirectoryProperty(context, flowFile, SOURCE_DIRECTORY);
                String destinationFileSystem = MoveAzureDataLakeStorage.evaluateFileSystemProperty(context, flowFile, DESTINATION_FILESYSTEM);
                String destinationDirectory = MoveAzureDataLakeStorage.evaluateDirectoryProperty(context, flowFile, DESTINATION_DIRECTORY);
                String fileName = MoveAzureDataLakeStorage.evaluateFileNameProperty(context, flowFile);
                Object destinationPath = !destinationDirectory.isEmpty() && !sourceDirectory.isEmpty() ? destinationDirectory + "/" : destinationDirectory;
                DataLakeServiceClient storageClient = this.getStorageClient((PropertyContext)context, flowFile);
                DataLakeFileSystemClient sourceFileSystemClient = storageClient.getFileSystemClient(sourceFileSystem);
                DataLakeDirectoryClient sourceDirectoryClient = sourceFileSystemClient.getDirectoryClient(sourceDirectory);
                DataLakeFileSystemClient destinationFileSystemClient = storageClient.getFileSystemClient(destinationFileSystem);
                DataLakeDirectoryClient destinationDirectoryClient = destinationFileSystemClient.getDirectoryClient(destinationDirectory);
                DataLakeFileClient sourceFileClient = sourceDirectoryClient.getFileClient(fileName);
                DataLakeRequestConditions sourceConditions = new DataLakeRequestConditions();
                DataLakeRequestConditions destinationConditions = new DataLakeRequestConditions();
                String conflictResolution = context.getProperty(CONFLICT_RESOLUTION).getValue();
                try {
                    if (!destinationDirectory.isEmpty() && !destinationDirectoryClient.exists().booleanValue()) {
                        destinationDirectoryClient.create();
                    }
                    if (!conflictResolution.equals(REPLACE_RESOLUTION)) {
                        destinationConditions.setIfNoneMatch("*");
                    }
                    DataLakeFileClient destinationFileClient = (DataLakeFileClient)sourceFileClient.renameWithResponse(destinationFileSystem, (String)destinationPath + fileName, sourceConditions, destinationConditions, null, null).getValue();
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("azure.source.filesystem", sourceFileSystem);
                    attributes.put("azure.source.directory", sourceDirectory);
                    attributes.put("azure.filesystem", destinationFileSystem);
                    attributes.put("azure.directory", destinationDirectory);
                    attributes.put("azure.filename", fileName);
                    attributes.put("azure.primaryUri", destinationFileClient.getFileUrl());
                    attributes.put("azure.length", String.valueOf(destinationFileClient.getProperties().getFileSize()));
                    flowFile = session.putAllAttributes(flowFile, attributes);
                    session.transfer(flowFile, REL_SUCCESS);
                    long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                    session.getProvenanceReporter().send(flowFile, sourceFileClient.getFileUrl(), transferMillis);
                }
                catch (DataLakeStorageException dlsException) {
                    if (dlsException.getStatusCode() == 409 && conflictResolution.equals(IGNORE_RESOLUTION)) {
                        session.transfer(flowFile, REL_SUCCESS);
                        String warningMessage = String.format("File with the same name already exists. Remote file not modified. Transferring {} to success due to %s being set to '%s'.", CONFLICT_RESOLUTION.getDisplayName(), conflictResolution);
                        this.getLogger().warn(warningMessage, new Object[]{flowFile});
                        break block8;
                    }
                    throw dlsException;
                }
            }
            catch (Exception e) {
                this.getLogger().error("Failed to move file on Azure Data Lake Storage", (Throwable)e);
                flowFile = session.penalize(flowFile);
                session.transfer(flowFile, REL_FAILURE);
            }
        }
    }
}

