/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.eventhub.position;

import com.azure.core.util.BinaryData;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.processors.azure.eventhub.position.EventPositionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyBlobStorageEventPositionProvider
implements EventPositionProvider {
    private static final String LEASE_SEQUENCE_NUMBER_FIELD = "sequenceNumber";
    private static final Logger logger = LoggerFactory.getLogger(LegacyBlobStorageEventPositionProvider.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final BlobContainerAsyncClient blobContainerAsyncClient;
    private final String consumerGroup;

    public LegacyBlobStorageEventPositionProvider(BlobContainerAsyncClient blobContainerAsyncClient, String consumerGroup) {
        this.blobContainerAsyncClient = Objects.requireNonNull(blobContainerAsyncClient, "Client required");
        this.consumerGroup = Objects.requireNonNull(consumerGroup, "Consumer Group required");
    }

    @Override
    public Map<String, EventPosition> getInitialPartitionEventPosition() {
        Map<String, EventPosition> partitionEventPosition;
        if (this.containerExists()) {
            BlobListDetails blobListDetails = new BlobListDetails().setRetrieveMetadata(true);
            ListBlobsOptions listBlobsOptions = new ListBlobsOptions().setPrefix(this.consumerGroup).setDetails(blobListDetails);
            Iterable blobItems = this.blobContainerAsyncClient.listBlobs(listBlobsOptions).toIterable();
            partitionEventPosition = this.getPartitionEventPosition(blobItems);
        } else {
            partitionEventPosition = Collections.emptyMap();
        }
        return partitionEventPosition;
    }

    private Map<String, EventPosition> getPartitionEventPosition(Iterable<BlobItem> blobItems) {
        LinkedHashMap<String, EventPosition> partitionEventPosition = new LinkedHashMap<String, EventPosition>();
        for (BlobItem blobItem : blobItems) {
            if (Boolean.TRUE.equals(blobItem.isPrefix())) continue;
            String partitionId = this.getPartitionId(blobItem);
            EventPosition eventPosition = this.getEventPosition(blobItem);
            if (eventPosition == null) {
                logger.info("Legacy Event Position not found for Partition [{}] Blob [{}]", (Object)partitionId, (Object)blobItem.getName());
                continue;
            }
            partitionEventPosition.put(partitionId, eventPosition);
        }
        return partitionEventPosition;
    }

    private String getPartitionId(BlobItem blobItem) {
        String blobItemName = blobItem.getName();
        Path blobItemPath = Paths.get(blobItemName, new String[0]);
        Path blobItemFileName = blobItemPath.getFileName();
        return blobItemFileName.toString();
    }

    private EventPosition getEventPosition(BlobItem blobItem) {
        EventPosition eventPosition;
        String blobName = blobItem.getName();
        BlobAsyncClient blobAsyncClient = this.blobContainerAsyncClient.getBlobAsyncClient(blobName);
        if (this.itemExists(blobAsyncClient)) {
            BinaryData content = (BinaryData)blobAsyncClient.downloadContent().block();
            if (content == null) {
                throw new IllegalStateException(String.format("Legacy Event Position content not found [%s]", blobName));
            }
            try {
                JsonNode lease = objectMapper.readTree(content.toBytes());
                if (lease.hasNonNull(LEASE_SEQUENCE_NUMBER_FIELD)) {
                    JsonNode sequenceNumberField = lease.get(LEASE_SEQUENCE_NUMBER_FIELD);
                    long sequenceNumber = sequenceNumberField.asLong();
                    eventPosition = EventPosition.fromSequenceNumber((long)sequenceNumber);
                }
                eventPosition = null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Reading Legacy Event Position Failed [%s]", blobName), e);
            }
        } else {
            logger.info("Legacy Event Position not found [{}]", (Object)blobName);
            eventPosition = null;
        }
        return eventPosition;
    }

    private boolean containerExists() {
        return Boolean.TRUE.equals(this.blobContainerAsyncClient.exists().block());
    }

    private boolean itemExists(BlobAsyncClient blobAsyncClient) {
        return Boolean.TRUE.equals(blobAsyncClient.exists().block());
    }
}

