/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processor.util.list.ListableEntity;

public abstract class AbstractListAzureProcessor<T extends ListableEntity>
extends AbstractListProcessor<T> {
    public static final PropertyDescriptor MIN_AGE = new PropertyDescriptor.Builder().name("Minimum File Age").description("The minimum age that a file must be in order to be pulled; any file younger than this amount of time (according to last modification date) will be ignored").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor MAX_AGE = new PropertyDescriptor.Builder().name("Maximum File Age").description("The maximum age that a file must be in order to be pulled; any file older than this amount of time (according to last modification date) will be ignored").required(false).addValidator(StandardValidators.createTimePeriodValidator((long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (long)Long.MAX_VALUE, (TimeUnit)TimeUnit.NANOSECONDS)).build();
    public static final PropertyDescriptor MIN_SIZE = new PropertyDescriptor.Builder().name("Minimum File Size").description("The minimum size that a file must be in order to be pulled").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("0 B").build();
    public static final PropertyDescriptor MAX_SIZE = new PropertyDescriptor.Builder().name("Maximum File Size").description("The maximum size that a file can be in order to be pulled").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();

    protected boolean isFileInfoMatchesWithAgeAndSize(ProcessContext context, long minimumTimestamp, long lastModified, long size) {
        long minSize = context.getProperty(MIN_SIZE).asDataSize(DataUnit.B).longValue();
        Double maxSize = context.getProperty(MAX_SIZE).asDataSize(DataUnit.B);
        long minAge = context.getProperty(MIN_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        Long maxAge = context.getProperty(MAX_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        if (lastModified < minimumTimestamp) {
            return false;
        }
        long fileAge = System.currentTimeMillis() - lastModified;
        if (minAge > fileAge) {
            return false;
        }
        if (maxAge != null && maxAge < fileAge) {
            return false;
        }
        if (minSize > size) {
            return false;
        }
        return maxSize == null || !(maxSize < (double)size);
    }
}

