/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure;

import com.azure.core.cryptography.AsyncKeyEncryptionKey;
import com.azure.security.keyvault.keys.cryptography.KeyEncryptionKeyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobClientBuilder;
import com.azure.storage.blob.specialized.cryptography.EncryptionVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.storage.utils.ClientSideEncryptionMethod;
import org.apache.nifi.util.StringUtils;

public interface ClientSideEncryptionSupport {
    public static final List<KeyOperation> KEY_OPERATIONS = Arrays.asList(KeyOperation.WRAP_KEY, KeyOperation.UNWRAP_KEY);
    public static final PropertyDescriptor CSE_KEY_TYPE = new PropertyDescriptor.Builder().name("Client-Side Encryption Key Type").displayName("Client-Side Encryption Key Type").required(true).allowableValues(ClientSideEncryptionMethod.class).defaultValue(ClientSideEncryptionMethod.NONE.getValue()).description("Specifies the key type to use for client-side encryption.").build();
    public static final PropertyDescriptor CSE_KEY_ID = new PropertyDescriptor.Builder().name("Client-Side Encryption Key ID").displayName("Client-Side Encryption Key ID").description("Specifies the ID of the key to use for client-side encryption.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(CSE_KEY_TYPE, (DescribedValue)ClientSideEncryptionMethod.LOCAL, new DescribedValue[0]).build();
    public static final PropertyDescriptor CSE_LOCAL_KEY = new PropertyDescriptor.Builder().name("Client-Side Encryption Local Key").displayName("Client-Side Encryption Local Key").description("When using local client-side encryption, this is the raw key, encoded in hexadecimal").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(CSE_KEY_TYPE, (DescribedValue)ClientSideEncryptionMethod.LOCAL, new DescribedValue[0]).sensitive(true).build();

    default public Collection<ValidationResult> validateClientSideEncryptionProperties(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        String cseKeyTypeValue = validationContext.getProperty(CSE_KEY_TYPE).getValue();
        ClientSideEncryptionMethod cseKeyType = ClientSideEncryptionMethod.valueOf(cseKeyTypeValue);
        String cseKeyId = validationContext.getProperty(CSE_KEY_ID).getValue();
        String cseLocalKey = validationContext.getProperty(CSE_LOCAL_KEY).getValue();
        if (cseKeyType != ClientSideEncryptionMethod.NONE && StringUtils.isBlank((String)cseKeyId)) {
            validationResults.add(new ValidationResult.Builder().subject(CSE_KEY_ID.getDisplayName()).explanation("Key ID must be set when client-side encryption is enabled").build());
        }
        if (ClientSideEncryptionMethod.LOCAL == cseKeyType) {
            validationResults.addAll(this.validateLocalKey(cseLocalKey));
        }
        return validationResults;
    }

    default public List<ValidationResult> validateLocalKey(String keyHex) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (StringUtils.isBlank((String)keyHex)) {
            validationResults.add(new ValidationResult.Builder().subject(CSE_LOCAL_KEY.getDisplayName()).explanation("Key must be set when client-side encryption is enabled").build());
        } else {
            try {
                byte[] keyBytes = Hex.decodeHex((String)keyHex);
                if (!this.getKeyWrapAlgorithm(keyBytes).isPresent()) {
                    validationResults.add(new ValidationResult.Builder().subject(CSE_LOCAL_KEY.getDisplayName()).explanation(String.format("Key size in bits must be one of [128, 192, 256, 384, 512] instead of [%d]", keyBytes.length * 8)).build());
                }
            }
            catch (DecoderException e) {
                validationResults.add(new ValidationResult.Builder().subject(CSE_LOCAL_KEY.getDisplayName()).explanation("Key must be a valid hexadecimal string").build());
            }
            catch (IllegalArgumentException e) {
                validationResults.add(new ValidationResult.Builder().subject(CSE_LOCAL_KEY.getDisplayName()).explanation(e.getMessage()).build());
            }
        }
        return validationResults;
    }

    default public boolean isClientSideEncryptionEnabled(PropertyContext context) {
        String cseKeyTypeValue = context.getProperty(CSE_KEY_TYPE).getValue();
        ClientSideEncryptionMethod cseKeyType = ClientSideEncryptionMethod.valueOf(cseKeyTypeValue);
        return cseKeyType != ClientSideEncryptionMethod.NONE;
    }

    default public BlobClient getEncryptedBlobClient(PropertyContext context, BlobContainerClient containerClient, String blobName) throws DecoderException {
        String cseKeyId = context.getProperty(CSE_KEY_ID).getValue();
        String cseLocalKeyHex = context.getProperty(CSE_LOCAL_KEY).getValue();
        BlobClient blobClient = containerClient.getBlobClient(blobName);
        byte[] keyBytes = Hex.decodeHex((String)cseLocalKeyHex);
        JsonWebKey localKey = JsonWebKey.fromAes((SecretKey)new SecretKeySpec(keyBytes, "AES"), KEY_OPERATIONS).setId(cseKeyId);
        AsyncKeyEncryptionKey akek = (AsyncKeyEncryptionKey)new KeyEncryptionKeyClientBuilder().buildAsyncKeyEncryptionKey(localKey).block();
        String keyWrapAlgorithm = this.getKeyWrapAlgorithm(keyBytes).orElseThrow(() -> new IllegalArgumentException("Failed to derive key wrap algorithm"));
        return new EncryptedBlobClientBuilder(EncryptionVersion.V2).key(akek, keyWrapAlgorithm).blobClient(blobClient).buildEncryptedBlobClient();
    }

    default public Optional<String> getKeyWrapAlgorithm(byte[] keyBytes) {
        int keySize128 = 16;
        int keySize192 = 24;
        int keySize256 = 32;
        int keySize384 = 48;
        int keySize512 = 64;
        switch (keyBytes.length) {
            case 16: {
                return Optional.of(KeyWrapAlgorithm.A128KW.toString());
            }
            case 24: {
                return Optional.of(KeyWrapAlgorithm.A192KW.toString());
            }
            case 32: 
            case 48: 
            case 64: {
                return Optional.of(KeyWrapAlgorithm.A256KW.toString());
            }
        }
        return Optional.empty();
    }
}

