/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.utils;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.services.azure.storage.ADLSCredentialsDetails;
import reactor.core.publisher.Mono;

public class DataLakeServiceClientFactory {
    private static final long STORAGE_CLIENT_CACHE_SIZE = 10L;
    private final ComponentLog logger;
    private final ProxyOptions proxyOptions;
    private final Cache<ADLSCredentialsDetails, DataLakeServiceClient> clientCache;

    public DataLakeServiceClientFactory(ComponentLog logger, ProxyOptions proxyOptions) {
        this.logger = logger;
        this.proxyOptions = proxyOptions;
        this.clientCache = this.createCache();
    }

    private Cache<ADLSCredentialsDetails, DataLakeServiceClient> createCache() {
        return Caffeine.newBuilder().maximumSize(10L).build();
    }

    public DataLakeServiceClient getStorageClient(ADLSCredentialsDetails credentialsDetails) {
        return (DataLakeServiceClient)this.clientCache.get((Object)credentialsDetails, __ -> {
            this.logger.debug("DataLakeServiceClient is not found in the cache with the given credentials. Creating it.");
            return DataLakeServiceClientFactory.createStorageClient(credentialsDetails, this.proxyOptions);
        });
    }

    private static DataLakeServiceClient createStorageClient(ADLSCredentialsDetails credentialsDetails, ProxyOptions proxyOptions) {
        StorageSharedKeyCredential credential;
        String accountName = credentialsDetails.getAccountName();
        String accountKey = credentialsDetails.getAccountKey();
        String sasToken = credentialsDetails.getSasToken();
        AccessToken accessToken = credentialsDetails.getAccessToken();
        String endpointSuffix = credentialsDetails.getEndpointSuffix();
        boolean useManagedIdentity = credentialsDetails.getUseManagedIdentity();
        String managedIdentityClientId = credentialsDetails.getManagedIdentityClientId();
        String servicePrincipalTenantId = credentialsDetails.getServicePrincipalTenantId();
        String servicePrincipalClientId = credentialsDetails.getServicePrincipalClientId();
        String servicePrincipalClientSecret = credentialsDetails.getServicePrincipalClientSecret();
        String endpoint = String.format("https://%s.%s", accountName, endpointSuffix);
        DataLakeServiceClientBuilder dataLakeServiceClientBuilder = new DataLakeServiceClientBuilder();
        dataLakeServiceClientBuilder.endpoint(endpoint);
        if (StringUtils.isNotBlank((CharSequence)accountKey)) {
            credential = new StorageSharedKeyCredential(accountName, accountKey);
            dataLakeServiceClientBuilder.credential(credential);
        } else if (StringUtils.isNotBlank((CharSequence)sasToken)) {
            dataLakeServiceClientBuilder.sasToken(sasToken);
        } else if (accessToken != null) {
            credential = tokenRequestContext -> Mono.just((Object)accessToken);
            dataLakeServiceClientBuilder.credential((TokenCredential)credential);
        } else if (useManagedIdentity) {
            ManagedIdentityCredential misCredential = new ManagedIdentityCredentialBuilder().clientId(managedIdentityClientId).build();
            dataLakeServiceClientBuilder.credential((TokenCredential)misCredential);
        } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{servicePrincipalTenantId, servicePrincipalClientId, servicePrincipalClientSecret})) {
            credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(servicePrincipalTenantId)).clientId(servicePrincipalClientId)).clientSecret(servicePrincipalClientSecret).build();
            dataLakeServiceClientBuilder.credential((TokenCredential)credential);
        } else {
            throw new IllegalArgumentException("No valid credentials were provided");
        }
        NettyAsyncHttpClientBuilder nettyClientBuilder = new NettyAsyncHttpClientBuilder();
        nettyClientBuilder.proxy(proxyOptions);
        HttpClient nettyClient = nettyClientBuilder.build();
        dataLakeServiceClientBuilder.httpClient(nettyClient);
        return dataLakeServiceClientBuilder.buildClient();
    }
}

