/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.cosmos.document;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processors.azure.cosmos.document.AzureCosmosDBUtils;
import org.apache.nifi.services.azure.cosmos.AzureCosmosDBConnectionService;
import org.apache.nifi.util.StringUtils;

@Tags(value={"azure", "cosmos", "document", "service"})
@CapabilityDescription(value="Provides a controller service that configures a connection to Cosmos DB (Core SQL API)  and provides access to that connection to other Cosmos DB-related components.")
public class AzureCosmosDBClientService
extends AbstractControllerService
implements AzureCosmosDBConnectionService {
    private String uri;
    private String accessKey;
    private String consistencyLevel;
    private CosmosClient cosmosClient;
    static List<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        ConsistencyLevel clevel;
        String selectedConsistency;
        this.uri = context.getProperty(AzureCosmosDBUtils.URI).getValue();
        this.accessKey = context.getProperty(AzureCosmosDBUtils.DB_ACCESS_KEY).getValue();
        switch (selectedConsistency = context.getProperty(AzureCosmosDBUtils.CONSISTENCY).getValue()) {
            case "STRONG": {
                clevel = ConsistencyLevel.STRONG;
                break;
            }
            case "CONSISTENT_PREFIX": {
                clevel = ConsistencyLevel.CONSISTENT_PREFIX;
                break;
            }
            case "SESSION": {
                clevel = ConsistencyLevel.SESSION;
                break;
            }
            case "BOUNDED_STALENESS": {
                clevel = ConsistencyLevel.BOUNDED_STALENESS;
                break;
            }
            case "EVENTUAL": {
                clevel = ConsistencyLevel.EVENTUAL;
                break;
            }
            default: {
                clevel = ConsistencyLevel.SESSION;
            }
        }
        if (this.cosmosClient != null) {
            this.onStopped();
        }
        this.consistencyLevel = clevel.toString();
        this.createCosmosClient(this.uri, this.accessKey, clevel);
    }

    @OnStopped
    public final void onStopped() {
        if (this.cosmosClient != null) {
            try {
                this.cosmosClient.close();
            }
            catch (CosmosException e) {
                this.getLogger().error("Closing cosmosClient Failed: " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.cosmosClient = null;
            }
        }
    }

    protected void createCosmosClient(String uri, String accessKey, ConsistencyLevel clevel) {
        this.cosmosClient = new CosmosClientBuilder().endpoint(uri).key(accessKey).consistencyLevel(clevel).buildClient();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return descriptors;
    }

    public String getURI() {
        return this.uri;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public CosmosClient getCosmosClient() {
        return this.cosmosClient;
    }

    public void setCosmosClient(CosmosClient client) {
        this.cosmosClient = client;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String uri = validationContext.getProperty(AzureCosmosDBUtils.URI).getValue();
        String accessKey = validationContext.getProperty(AzureCosmosDBUtils.DB_ACCESS_KEY).getValue();
        if (StringUtils.isBlank((String)uri) || StringUtils.isBlank((String)accessKey)) {
            results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).valid(false).explanation("either " + AzureCosmosDBUtils.URI.getDisplayName() + " or " + AzureCosmosDBUtils.DB_ACCESS_KEY.getDisplayName() + " is required").build());
        }
        return results;
    }

    static {
        descriptors.add(AzureCosmosDBUtils.URI);
        descriptors.add(AzureCosmosDBUtils.DB_ACCESS_KEY);
        descriptors.add(AzureCosmosDBUtils.CONSISTENCY);
    }
}

