/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails_v12;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsService_v12;
import reactor.core.publisher.Mono;

public abstract class AbstractAzureBlobProcessor_v12
extends AbstractProcessor {
    public static final PropertyDescriptor STORAGE_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("storage-credentials-service").displayName("Storage Credentials").description("Controller Service used to obtain Azure Blob Storage Credentials.").identifiesControllerService(AzureStorageCredentialsService_v12.class).required(true).build();
    public static final PropertyDescriptor BLOB_NAME = new PropertyDescriptor.Builder().name("blob-name").displayName("Blob Name").description("The full name of the blob").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All successfully processed FlowFiles are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Unsuccessful operations will be transferred to the failure relationship.").build();
    private static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    private BlobServiceClient storageClient;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.storageClient = AbstractAzureBlobProcessor_v12.createStorageClient((PropertyContext)context);
    }

    @OnStopped
    public void onStopped() {
        this.storageClient = null;
    }

    protected BlobServiceClient getStorageClient() {
        return this.storageClient;
    }

    public static BlobServiceClient createStorageClient(PropertyContext context) {
        AzureStorageCredentialsService_v12 credentialsService = (AzureStorageCredentialsService_v12)context.getProperty(STORAGE_CREDENTIALS_SERVICE).asControllerService(AzureStorageCredentialsService_v12.class);
        AzureStorageCredentialsDetails_v12 credentialsDetails = credentialsService.getCredentialsDetails();
        BlobServiceClientBuilder clientBuilder = new BlobServiceClientBuilder();
        clientBuilder.endpoint(String.format("https://%s.%s", credentialsDetails.getAccountName(), credentialsDetails.getEndpointSuffix()));
        NettyAsyncHttpClientBuilder nettyClientBuilder = new NettyAsyncHttpClientBuilder();
        nettyClientBuilder.proxy(AzureStorageUtils.getProxyOptions(context));
        HttpClient nettyClient = nettyClientBuilder.build();
        clientBuilder.httpClient(nettyClient);
        AbstractAzureBlobProcessor_v12.configureCredential(clientBuilder, credentialsService, credentialsDetails);
        return clientBuilder.buildClient();
    }

    private static void configureCredential(BlobServiceClientBuilder clientBuilder, AzureStorageCredentialsService_v12 credentialsService, AzureStorageCredentialsDetails_v12 credentialsDetails) {
        switch (credentialsDetails.getCredentialsType()) {
            case ACCOUNT_KEY: {
                clientBuilder.credential(new StorageSharedKeyCredential(credentialsDetails.getAccountName(), credentialsDetails.getAccountKey()));
                break;
            }
            case SAS_TOKEN: {
                clientBuilder.credential(new AzureSasCredential(credentialsDetails.getSasToken()));
                break;
            }
            case MANAGED_IDENTITY: {
                clientBuilder.credential((TokenCredential)new ManagedIdentityCredentialBuilder().clientId(credentialsDetails.getManagedIdentityClientId()).build());
                break;
            }
            case SERVICE_PRINCIPAL: {
                clientBuilder.credential((TokenCredential)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(credentialsDetails.getServicePrincipalTenantId())).clientId(credentialsDetails.getServicePrincipalClientId())).clientSecret(credentialsDetails.getServicePrincipalClientSecret()).build());
                break;
            }
            case ACCESS_TOKEN: {
                TokenCredential credential = tokenRequestContext -> Mono.just((Object)credentialsService.getCredentialsDetails().getAccessToken());
                clientBuilder.credential(credential);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled credentials type: " + credentialsDetails.getCredentialsType());
            }
        }
    }

    protected Map<String, String> createBlobAttributesMap(BlobClient blobClient) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.applyStandardBlobAttributes(attributes, blobClient);
        this.applyBlobMetadata(attributes, blobClient);
        return attributes;
    }

    protected void applyStandardBlobAttributes(Map<String, String> attributes, BlobClient blobClient) {
        String primaryUri = blobClient.getBlobUrl().replace("%2F", "/");
        attributes.put("azure.container", blobClient.getContainerName());
        attributes.put("azure.blobname", blobClient.getBlobName());
        attributes.put("azure.primaryUri", primaryUri);
    }

    protected void applyBlobMetadata(Map<String, String> attributes, BlobClient blobClient) {
        BlobProperties properties = blobClient.getProperties();
        attributes.put("azure.etag", properties.getETag());
        attributes.put("azure.blobtype", properties.getBlobType().toString());
        attributes.put("mime.type", properties.getContentType());
        attributes.put("lang", properties.getContentLanguage());
        attributes.put("azure.timestamp", String.valueOf(properties.getLastModified()));
        attributes.put("azure.length", String.valueOf(properties.getBlobSize()));
    }
}

