/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobRange;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.AbstractAzureBlobProcessor_v12;
import org.apache.nifi.processors.azure.storage.DeleteAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.ListAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.PutAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob"})
@CapabilityDescription(value="Retrieves the specified blob from Azure Blob Storage and writes its content to the content of the FlowFile. The processor uses Azure Blob Storage client library v12.")
@SeeAlso(value={ListAzureBlobStorage_v12.class, PutAzureBlobStorage_v12.class, DeleteAzureBlobStorage_v12.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="azure.container", description="The name of the Azure Blob Storage container"), @WritesAttribute(attribute="azure.blobname", description="The name of the blob on Azure Blob Storage"), @WritesAttribute(attribute="azure.primaryUri", description="Primary location of the blob"), @WritesAttribute(attribute="azure.etag", description="ETag of the blob"), @WritesAttribute(attribute="azure.blobtype", description="Type of the blob (either BlockBlob, PageBlob or AppendBlob)"), @WritesAttribute(attribute="mime.type", description="MIME Type of the content"), @WritesAttribute(attribute="lang", description="Language code for the content"), @WritesAttribute(attribute="azure.timestamp", description="Timestamp of the blob"), @WritesAttribute(attribute="azure.length", description="Length of the blob")})
public class FetchAzureBlobStorage_v12
extends AbstractAzureBlobProcessor_v12 {
    public static final PropertyDescriptor CONTAINER = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.CONTAINER).defaultValue("${azure.container}").build();
    public static final PropertyDescriptor BLOB_NAME = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractAzureBlobProcessor_v12.BLOB_NAME).defaultValue("${azure.blobname}").build();
    public static final PropertyDescriptor RANGE_START = new PropertyDescriptor.Builder().name("range-start").displayName("Range Start").description("The byte position at which to start reading from the blob. An empty value or a value of zero will start reading at the beginning of the blob.").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    public static final PropertyDescriptor RANGE_LENGTH = new PropertyDescriptor.Builder().name("range-length").displayName("Range Length").description("The number of bytes to download from the blob, starting from the Range Start. An empty value or a value that extends beyond the end of the blob will read to the end of the blob.").addValidator(StandardValidators.createDataSizeBoundsValidator((long)1L, (long)Long.MAX_VALUE)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(STORAGE_CREDENTIALS_SERVICE, CONTAINER, BLOB_NAME, RANGE_START, RANGE_LENGTH, AzureStorageUtils.PROXY_CONFIGURATION_SERVICE));

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        String containerName = context.getProperty(CONTAINER).evaluateAttributeExpressions(flowFile).getValue();
        String blobName = context.getProperty(BLOB_NAME).evaluateAttributeExpressions(flowFile).getValue();
        long rangeStart = context.getProperty(RANGE_START).isSet() ? context.getProperty(RANGE_START).evaluateAttributeExpressions(flowFile).asDataSize(DataUnit.B).longValue() : 0L;
        Long rangeLength = context.getProperty(RANGE_LENGTH).isSet() ? Long.valueOf(context.getProperty(RANGE_LENGTH).evaluateAttributeExpressions(flowFile).asDataSize(DataUnit.B).longValue()) : null;
        try {
            BlobServiceClient storageClient = this.getStorageClient();
            BlobContainerClient containerClient = storageClient.getBlobContainerClient(containerName);
            BlobClient blobClient = containerClient.getBlobClient(blobName);
            flowFile = session.write(flowFile, os -> blobClient.downloadWithResponse(os, new BlobRange(rangeStart, rangeLength), null, null, false, null, null));
            Map<String, String> attributes = this.createBlobAttributesMap(blobClient);
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.transfer(flowFile, REL_SUCCESS);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            String transitUri = attributes.get("azure.primaryUri");
            session.getProvenanceReporter().fetch(flowFile, transitUri, transferMillis);
        }
        catch (Exception e) {
            this.getLogger().error("Failure to fetch Azure blob {}", new Object[]{blobName, e});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

