/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.azure;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserAndGroups;

public class ImmutableAzureGraphUserGroup {
    private final Set<User> users;
    private final Map<String, User> usersByObjectId;
    private final Map<String, User> usersByPrincipalName;
    private final Map<String, UserAndGroups> usersAndGroupsByUserObjectId;
    private final Set<Group> groups;
    private final Map<String, Group> groupsByObjectId;
    private final Map<String, Group> groupsByDisplayName;

    private ImmutableAzureGraphUserGroup(Set<User> users, Map<String, User> usersByObjectId, Map<String, User> usersByPrincipalName, Map<String, UserAndGroups> usersAndGroupsByUserObjectId, Set<Group> groups, Map<String, Group> groupsByObjectId, Map<String, Group> groupsByDisplayName) {
        this.users = Collections.unmodifiableSet(users);
        this.usersByObjectId = Collections.unmodifiableMap(usersByObjectId);
        this.usersByPrincipalName = Collections.unmodifiableMap(usersByPrincipalName);
        this.usersAndGroupsByUserObjectId = Collections.unmodifiableMap(usersAndGroupsByUserObjectId);
        this.groups = Collections.unmodifiableSet(groups);
        this.groupsByObjectId = Collections.unmodifiableMap(groupsByObjectId);
        this.groupsByDisplayName = Collections.unmodifiableMap(groupsByDisplayName);
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public User getUser(String objectId) {
        return this.usersByObjectId.get(objectId);
    }

    public User getUserByPrincipalName(String principalName) {
        return this.usersByPrincipalName.get(principalName);
    }

    public UserAndGroups getUserAndGroupsByUserObjectId(String objectId) {
        return this.usersAndGroupsByUserObjectId.get(objectId);
    }

    public UserAndGroups getUserAndGroups(String principalName) {
        User user = this.getUserByPrincipalName(principalName);
        if (user != null) {
            String objectId = user.getIdentifier();
            return this.getUserAndGroupsByUserObjectId(objectId);
        }
        return new UserAndGroups(){

            public User getUser() {
                return null;
            }

            public Set<Group> getGroups() {
                return null;
            }
        };
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public Group getGroup(String objectId) {
        return this.groupsByObjectId.get(objectId);
    }

    public Group getGroupByDisplayName(String displayName) {
        return this.groupsByDisplayName.get(displayName);
    }

    public static ImmutableAzureGraphUserGroup newInstance(Set<User> users, Set<Group> groups) {
        final HashMap<String, User> usersByObjectId = new HashMap<String, User>();
        HashMap<String, User> usersByPrincipalName = new HashMap<String, User>();
        users.forEach(user -> {
            usersByObjectId.put(user.getIdentifier(), (User)user);
            usersByPrincipalName.put(user.getIdentity(), (User)user);
        });
        HashMap<String, Group> groupsByObjectId = new HashMap<String, Group>();
        HashMap<String, Group> groupsByDisplayName = new HashMap<String, Group>();
        Map<String, Set> groupsByUserObjectId = users.stream().collect(Collectors.toMap(User::getIdentifier, user -> new HashSet()));
        groups.forEach(group -> {
            groupsByObjectId.put(group.getIdentifier(), (Group)group);
            groupsByDisplayName.put(group.getName(), (Group)group);
            group.getUsers().forEach(user -> ((Set)groupsByUserObjectId.get(user)).add(group));
        });
        Map<String, UserAndGroups> usersAndGroupsByUserObjectId = groupsByUserObjectId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new UserAndGroups((Map.Entry)e){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
            }

            public User getUser() {
                return (User)usersByObjectId.get(this.val$e.getKey());
            }

            public Set<Group> getGroups() {
                return (Set)this.val$e.getValue();
            }
        }));
        return new ImmutableAzureGraphUserGroup(users, usersByObjectId, usersByPrincipalName, usersAndGroupsByUserObjectId, groups, groupsByObjectId, groupsByDisplayName);
    }
}

