/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.textract;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.textract.AmazonTextractClient;
import com.amazonaws.services.textract.AmazonTextractClientBuilder;
import com.amazonaws.services.textract.model.StartDocumentAnalysisRequest;
import com.amazonaws.services.textract.model.StartDocumentAnalysisResult;
import com.amazonaws.services.textract.model.StartDocumentTextDetectionRequest;
import com.amazonaws.services.textract.model.StartDocumentTextDetectionResult;
import com.amazonaws.services.textract.model.StartExpenseAnalysisRequest;
import com.amazonaws.services.textract.model.StartExpenseAnalysisResult;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.aws.ml.AwsMachineLearningJobStarter;
import org.apache.nifi.processors.aws.ml.textract.GetAwsTextractJobStatus;
import org.apache.nifi.processors.aws.ml.textract.TextractType;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Textract"})
@CapabilityDescription(value="Trigger a AWS Textract job. It should be followed by GetAwsTextractJobStatus processor in order to monitor job status.")
@SeeAlso(value={GetAwsTextractJobStatus.class})
public class StartAwsTextractJob
extends AwsMachineLearningJobStarter<AmazonTextractClient, AmazonWebServiceRequest, AmazonWebServiceResult> {
    public static final Validator TEXTRACT_TYPE_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
            }
            if (TextractType.TEXTRACT_TYPES.contains(value)) {
                return new ValidationResult.Builder().subject(subject).input(value).explanation("Supported Value.").valid(true).build();
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation("Not a supported value, flow file attribute or context parameter.").valid(false).build();
        }
    };
    public static final PropertyDescriptor TEXTRACT_TYPE = new PropertyDescriptor.Builder().name("textract-type").displayName("Textract Type").required(true).description("Supported values: \"Document Analysis\", \"Document Text Detection\", \"Expense Analysis\"").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue(TextractType.DOCUMENT_ANALYSIS.type).addValidator(TEXTRACT_TYPE_VALIDATOR).build();
    private static final List<PropertyDescriptor> TEXTRACT_PROPERTIES = Collections.unmodifiableList(Stream.concat(PROPERTIES.stream(), Stream.of(TEXTRACT_TYPE)).collect(Collectors.toList()));

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return TEXTRACT_PROPERTIES;
    }

    @Override
    protected void postProcessFlowFile(ProcessContext context, ProcessSession session, FlowFile flowFile, AmazonWebServiceResult response) {
        super.postProcessFlowFile(context, session, flowFile, response);
    }

    protected AmazonTextractClient createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        return (AmazonTextractClient)((AmazonTextractClientBuilder)((AmazonTextractClientBuilder)AmazonTextractClient.builder().withRegion(context.getProperty(REGION).getValue())).withCredentials(credentialsProvider)).build();
    }

    @Override
    protected AmazonWebServiceResult sendRequest(AmazonWebServiceRequest request, ProcessContext context, FlowFile flowFile) {
        TextractType textractType = TextractType.fromString(context.getProperty(TEXTRACT_TYPE.getName()).evaluateAttributeExpressions(flowFile).getValue());
        return switch (textractType) {
            case TextractType.DOCUMENT_ANALYSIS -> ((AmazonTextractClient)this.getClient(context)).startDocumentAnalysis((StartDocumentAnalysisRequest)request);
            case TextractType.DOCUMENT_TEXT_DETECTION -> ((AmazonTextractClient)this.getClient(context)).startDocumentTextDetection((StartDocumentTextDetectionRequest)request);
            case TextractType.EXPENSE_ANALYSIS -> ((AmazonTextractClient)this.getClient(context)).startExpenseAnalysis((StartExpenseAnalysisRequest)request);
            default -> throw new UnsupportedOperationException("Unsupported textract type: " + textractType);
        };
    }

    @Override
    protected Class<? extends AmazonWebServiceRequest> getAwsRequestClass(ProcessContext context, FlowFile flowFile) {
        TextractType typeOfTextract = TextractType.fromString(context.getProperty(TEXTRACT_TYPE.getName()).evaluateAttributeExpressions(flowFile).getValue());
        Class<StartDocumentAnalysisRequest> result = null;
        switch (typeOfTextract) {
            case DOCUMENT_ANALYSIS: {
                result = StartDocumentAnalysisRequest.class;
                break;
            }
            case DOCUMENT_TEXT_DETECTION: {
                result = StartDocumentTextDetectionRequest.class;
                break;
            }
            case EXPENSE_ANALYSIS: {
                result = StartExpenseAnalysisRequest.class;
            }
        }
        return result;
    }

    @Override
    protected String getAwsTaskId(ProcessContext context, AmazonWebServiceResult amazonWebServiceResult, FlowFile flowFile) {
        TextractType textractType = TextractType.fromString(context.getProperty(TEXTRACT_TYPE.getName()).evaluateAttributeExpressions(flowFile).getValue());
        return switch (textractType) {
            case TextractType.DOCUMENT_ANALYSIS -> ((StartDocumentAnalysisResult)amazonWebServiceResult).getJobId();
            case TextractType.DOCUMENT_TEXT_DETECTION -> ((StartDocumentTextDetectionResult)amazonWebServiceResult).getJobId();
            case TextractType.EXPENSE_ANALYSIS -> ((StartExpenseAnalysisResult)amazonWebServiceResult).getJobId();
            default -> throw new UnsupportedOperationException("Unsupported textract type.");
        };
    }
}

