/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;

public class NamedProfileCredentialsStrategy
extends AbstractCredentialsStrategy {
    public NamedProfileCredentialsStrategy() {
        super("Named Profile", new PropertyDescriptor[]{CredentialPropertyDescriptors.PROFILE_NAME});
    }

    @Override
    public AWSCredentialsProvider getCredentialsProvider(PropertyContext propertyContext) {
        String profileName = propertyContext.getProperty(CredentialPropertyDescriptors.PROFILE_NAME).evaluateAttributeExpressions().getValue();
        return new com.amazonaws.auth.profile.ProfileCredentialsProvider(profileName);
    }

    @Override
    public AwsCredentialsProvider getAwsCredentialsProvider(PropertyContext propertyContext) {
        String profileName = propertyContext.getProperty(CredentialPropertyDescriptors.PROFILE_NAME).evaluateAttributeExpressions().getValue();
        return ProfileCredentialsProvider.create((String)profileName);
    }
}

