/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.translate;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.textract.model.ThrottlingException;
import com.amazonaws.services.translate.AmazonTranslateClient;
import com.amazonaws.services.translate.AmazonTranslateClientBuilder;
import com.amazonaws.services.translate.model.DescribeTextTranslationJobRequest;
import com.amazonaws.services.translate.model.DescribeTextTranslationJobResult;
import com.amazonaws.services.translate.model.JobStatus;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.ml.AwsMachineLearningJobStatusProcessor;
import org.apache.nifi.processors.aws.ml.translate.StartAwsTranslateJob;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Translate"})
@CapabilityDescription(value="Retrieves the current status of an AWS Translate job.")
@SeeAlso(value={StartAwsTranslateJob.class})
@WritesAttributes(value={@WritesAttribute(attribute="outputLocation", description="S3 path-style output location of the result.")})
public class GetAwsTranslateJobStatus
extends AwsMachineLearningJobStatusProcessor<AmazonTranslateClient> {
    protected AmazonTranslateClient createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        return (AmazonTranslateClient)((AmazonTranslateClientBuilder)((AmazonTranslateClientBuilder)AmazonTranslateClient.builder().withRegion(context.getProperty(REGION).getValue())).withCredentials(credentialsProvider)).build();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String awsTaskId = context.getProperty(TASK_ID).evaluateAttributeExpressions(flowFile).getValue();
        try {
            DescribeTextTranslationJobResult describeTextTranslationJobResult = this.getStatusString(context, awsTaskId);
            JobStatus status = JobStatus.fromValue((String)describeTextTranslationJobResult.getTextTranslationJobProperties().getJobStatus());
            if (status == JobStatus.IN_PROGRESS || status == JobStatus.SUBMITTED) {
                this.writeToFlowFile(session, flowFile, describeTextTranslationJobResult);
                session.penalize(flowFile);
                session.transfer(flowFile, REL_RUNNING);
            } else if (status == JobStatus.COMPLETED) {
                session.putAttribute(flowFile, "outputLocation", describeTextTranslationJobResult.getTextTranslationJobProperties().getOutputDataConfig().getS3Uri());
                this.writeToFlowFile(session, flowFile, describeTextTranslationJobResult);
                session.transfer(flowFile, REL_SUCCESS);
            } else if (status == JobStatus.FAILED || status == JobStatus.COMPLETED_WITH_ERROR) {
                this.writeToFlowFile(session, flowFile, describeTextTranslationJobResult);
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (ThrottlingException e) {
            this.getLogger().info("Request Rate Limit exceeded", (Throwable)e);
            session.transfer(flowFile, REL_THROTTLED);
            return;
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to get Polly Job status", (Throwable)e);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
    }

    private DescribeTextTranslationJobResult getStatusString(ProcessContext context, String awsTaskId) {
        DescribeTextTranslationJobRequest request = new DescribeTextTranslationJobRequest().withJobId(awsTaskId);
        DescribeTextTranslationJobResult translationJobsResult = ((AmazonTranslateClient)this.getClient(context)).describeTextTranslationJob(request);
        return translationJobsResult;
    }
}

