/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.wag;

import com.amazonaws.http.AmazonHttpClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.wag.AbstractAWSGatewayApiProcessor;
import org.apache.nifi.processors.aws.wag.client.GenericApiGatewayClient;
import org.apache.nifi.processors.aws.wag.client.GenericApiGatewayException;
import org.apache.nifi.processors.aws.wag.client.GenericApiGatewayRequest;
import org.apache.nifi.processors.aws.wag.client.GenericApiGatewayResponse;
import org.apache.nifi.stream.io.StreamUtils;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@Tags(value={"Amazon", "AWS", "Client", "Gateway-API", "Rest", "http", "https"})
@CapabilityDescription(value="Client for AWS Gateway API endpoint")
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="The MIME Type of the flowfiles"), @WritesAttribute(attribute="aws.gateway.api.status.code", description="The status code that is returned"), @WritesAttribute(attribute="aws.gateway.api.status.message", description="The status message that is returned"), @WritesAttribute(attribute="aws.gateway.api.response.body", description="In the instance where the status code received is not a success (2xx)"), @WritesAttribute(attribute="aws.gateway.api.resource", description="The request resource"), @WritesAttribute(attribute="aws.gateway.api.tx.id", description="The transaction ID that is returned after reading the response"), @WritesAttribute(attribute="aws.gateway.api.java.exception.class", description="The Java exception class raised when the processor fails"), @WritesAttribute(attribute="aws.gateway.api.java.exception.message", description="The Java exception message raised when the processor fails")})
@DynamicProperty(name="Header Name", value="Attribute Expression Language", supportsExpressionLanguage=true, description="Send request header with a key matching the Dynamic Property Key and a value created by evaluating the Attribute Expression Language set in the value of the Dynamic Property.")
@DeprecationNotice(reason="Planned for removal in NiFi 2.0.  InvokeHTTP is the preferred alternative processor.")
public class InvokeAWSGatewayApi
extends AbstractAWSGatewayApiProcessor {
    private static final Set<String> IDEMPOTENT_METHODS = new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS"));
    public static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(PROP_METHOD, PROP_AWS_GATEWAY_API_REGION, ACCESS_KEY, SECRET_KEY, CREDENTIALS_FILE, AWS_CREDENTIALS_PROVIDER_SERVICE, TIMEOUT, PROP_RESOURCE_NAME, PROP_AWS_GATEWAY_API_ENDPOINT, PROP_AWS_API_KEY, PROP_ATTRIBUTES_TO_SEND, PROP_PUT_OUTPUT_IN_ATTRIBUTE, PROP_CONTENT_TYPE, PROP_SEND_BODY, PROP_OUTPUT_RESPONSE_REGARDLESS, PROP_PENALIZE_NO_RETRY, PROXY_HOST, PROXY_HOST_PORT, PROXY_USERNAME, PROXY_PASSWORD, PROP_QUERY_PARAMS, PROP_PUT_ATTRIBUTE_MAX_LENGTH, PROP_ADD_HEADERS_TO_REQUEST, PROXY_CONFIGURATION_SERVICE));
    public static final Relationship REL_SUCCESS_REQ = new Relationship.Builder().name("Original").description("The original FlowFile will be routed upon success (2xx status codes). It will have new  attributes detailing the success of the request.").build();
    public static final Relationship REL_RESPONSE = new Relationship.Builder().name("Response").description("A Response FlowFile will be routed upon success (2xx status codes). If the 'Output Response Regardless' property is true then the response will be sent to this relationship regardless of the status code received.").build();
    public static final Relationship REL_RETRY = new Relationship.Builder().name("Retry").description("The original FlowFile will be routed on any status code that can be retried (5xx status codes). It will have new attributes detailing the request.").build();
    public static final Relationship REL_NO_RETRY = new Relationship.Builder().name("No Retry").description("The original FlowFile will be routed on any status code that should NOT be retried (1xx, 3xx, 4xx status codes).  It will have new attributes detailing the request.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("Failure").description("The original FlowFile will be routed on any type of connection failure, timeout or general exception. It will have new attributes detailing the request.").build();
    public static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS_REQ, REL_RESPONSE, REL_RETRY, REL_NO_RETRY, REL_FAILURE)));

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public InvokeAWSGatewayApi() {
    }

    public InvokeAWSGatewayApi(AmazonHttpClient client) {
        super(client);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ComponentLog logger = this.getLogger();
        FlowFile requestFlowFile = session.get();
        boolean putToAttribute = context.getProperty(PROP_PUT_OUTPUT_IN_ATTRIBUTE).isSet();
        if (requestFlowFile == null) {
            String request = context.getProperty(PROP_METHOD).evaluateAttributeExpressions().getValue().toUpperCase();
            if ("POST".equals(request) || "PUT".equals(request) || "PATCH".equals(request)) {
                return;
            }
            if (putToAttribute) {
                requestFlowFile = session.create();
            }
        }
        UUID txId = UUID.randomUUID();
        FlowFile responseFlowFile = null;
        try {
            int maxAttributeSize = context.getProperty(PROP_PUT_ATTRIBUTE_MAX_LENGTH).asInteger();
            String resourceName = context.getProperty(PROP_RESOURCE_NAME).getValue();
            GenericApiGatewayClient client = (GenericApiGatewayClient)this.getClient(context);
            long startNanos = System.nanoTime();
            Map attributes = requestFlowFile == null ? Collections.emptyMap() : requestFlowFile.getAttributes();
            GatewayResponse gatewayResponse = this.invokeGateway(client, context, session, requestFlowFile, attributes, logger);
            GenericApiGatewayResponse response = gatewayResponse.response;
            GenericApiGatewayException exception = gatewayResponse.exception;
            int statusCode = gatewayResponse.statusCode;
            String endpoint = context.getProperty(PROP_AWS_GATEWAY_API_ENDPOINT).getValue();
            boolean outputRegardless = context.getProperty(PROP_OUTPUT_RESPONSE_REGARDLESS).asBoolean();
            boolean outputBodyToResponseContent = this.isSuccess(statusCode) && !putToAttribute || outputRegardless;
            boolean outputBodyToRequestAttribute = (!this.isSuccess(statusCode) || putToAttribute) && requestFlowFile != null;
            boolean bodyExists = response != null && response.getBody() != null;
            String statusExplanation = exception != null ? EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, null) : response.getHttpResponse().getStatusText();
            HashMap<String, String> statusAttributes = new HashMap<String, String>();
            statusAttributes.put("aws.gateway.api.status.code", String.valueOf(statusCode));
            statusAttributes.put("aws.gateway.api.status.message", statusExplanation);
            statusAttributes.put("aws.gateway.api.endpoint", client.getEndpointPrefix());
            statusAttributes.put("aws.gateway.api.resource", resourceName);
            statusAttributes.put("aws.gateway.api.tx.id", txId.toString());
            if (outputBodyToResponseContent) {
                long millis;
                String contentType;
                if (requestFlowFile != null) {
                    responseFlowFile = session.create(requestFlowFile);
                    requestFlowFile = session.putAllAttributes(requestFlowFile, statusAttributes);
                    if (context.getProperty(PROP_ADD_HEADERS_TO_REQUEST).asBoolean().booleanValue()) {
                        requestFlowFile = session.putAllAttributes(requestFlowFile, this.convertAttributesFromHeaders(response));
                    }
                } else {
                    responseFlowFile = session.create();
                }
                responseFlowFile = session.putAllAttributes(responseFlowFile, statusAttributes);
                responseFlowFile = response != null ? session.putAllAttributes(responseFlowFile, this.convertAttributesFromHeaders(response)) : session.putAllAttributes(responseFlowFile, exception.getHttpHeaders());
                if (bodyExists) {
                    contentType = (String)response.getHttpResponse().getHeaders().get("Content-Type");
                    if (contentType != null && !contentType.trim().isEmpty()) {
                        responseFlowFile = session.putAttribute(responseFlowFile, CoreAttributes.MIME_TYPE.key(), contentType.trim());
                    }
                    responseFlowFile = session.importFrom((InputStream)new ByteArrayInputStream(response.getBody().getBytes()), responseFlowFile);
                    millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                    if (requestFlowFile != null) {
                        session.getProvenanceReporter().fetch(responseFlowFile, endpoint, millis);
                    } else {
                        session.getProvenanceReporter().receive(responseFlowFile, endpoint, millis);
                    }
                } else if (exception != null) {
                    contentType = "application/json";
                    responseFlowFile = session.putAttribute(responseFlowFile, CoreAttributes.MIME_TYPE.key(), "application/json".trim());
                    responseFlowFile = session.importFrom((InputStream)new ByteArrayInputStream(exception.getRawResponse()), responseFlowFile);
                    millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                    if (requestFlowFile != null) {
                        session.getProvenanceReporter().fetch(responseFlowFile, endpoint, millis);
                    } else {
                        session.getProvenanceReporter().receive(responseFlowFile, endpoint, millis);
                    }
                }
            }
            if (outputBodyToRequestAttribute) {
                String attributeKey = context.getProperty(PROP_PUT_OUTPUT_IN_ATTRIBUTE).evaluateAttributeExpressions(requestFlowFile).getValue();
                if (attributeKey == null) {
                    attributeKey = "aws.gateway.api.response.body";
                }
                int size = 0;
                byte[] outputBuffer = new byte[maxAttributeSize];
                if (bodyExists) {
                    size = StreamUtils.fillBuffer((InputStream)new ByteArrayInputStream(response.getBody().getBytes()), (byte[])outputBuffer, (boolean)false);
                } else if (exception != null && exception.getRawResponse() != null && exception.getRawResponse().length > 0) {
                    size = StreamUtils.fillBuffer((InputStream)new ByteArrayInputStream(exception.getRawResponse()), (byte[])outputBuffer, (boolean)false);
                }
                if (size > 0) {
                    String bodyString = new String(outputBuffer, 0, size, "UTF-8");
                    requestFlowFile = session.putAttribute(requestFlowFile, attributeKey, bodyString);
                }
                requestFlowFile = session.putAllAttributes(requestFlowFile, statusAttributes);
                long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                session.getProvenanceReporter().modifyAttributes(requestFlowFile, String.format("The %s has been added. The value of which is the body of a http call to %s%s. It took %s millis,", attributeKey, endpoint, resourceName, millis));
            }
            this.route(requestFlowFile, responseFlowFile, session, context, statusCode, this.getRelationships());
        }
        catch (Exception e) {
            if (requestFlowFile != null) {
                logger.error("Routing to {} due to exception: {}", new Object[]{REL_FAILURE.getName(), e, e});
                requestFlowFile = session.penalize(requestFlowFile);
                requestFlowFile = session.putAttribute(requestFlowFile, "aws.gateway.api.java.exception.class", e.getClass().getName());
                requestFlowFile = session.putAttribute(requestFlowFile, "aws.gateway.api.java.exception.message", e.getMessage());
                session.transfer(requestFlowFile, this.getRelationshipForName("Failure", this.getRelationships()));
            } else {
                logger.error("Yielding processor due to exception encountered as a source processor: {}", (Throwable)e);
                context.yield();
            }
            try {
                if (responseFlowFile != null) {
                    session.remove(responseFlowFile);
                }
            }
            catch (Exception e1) {
                logger.error("Could not cleanup response flowfile due to exception: {}", new Object[]{e1, e1});
            }
        }
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>(super.verify(context, verificationLogger, attributes));
        String method = context.getProperty(PROP_METHOD).getValue();
        if (!IDEMPOTENT_METHODS.contains(method)) {
            return results;
        }
        String endpoint = context.getProperty(PROP_AWS_GATEWAY_API_ENDPOINT).getValue();
        String resource = context.getProperty(PROP_RESOURCE_NAME).getValue();
        try {
            String explanation;
            GenericApiGatewayClient client = (GenericApiGatewayClient)this.getClient(context);
            GatewayResponse gatewayResponse = this.invokeGateway(client, context, null, null, attributes, verificationLogger);
            if (gatewayResponse.exception != null) {
                String statusExplanation = EnglishReasonPhraseCatalog.INSTANCE.getReason(gatewayResponse.statusCode, null);
                explanation = String.format("Successfully invoked AWS Gateway API [%s %s/%s] with blank request body, receiving error response [%s] with status code [%s]", method, endpoint, resource, statusExplanation, gatewayResponse.statusCode);
            } else {
                String statusExplanation = gatewayResponse.response.getHttpResponse().getStatusText();
                explanation = String.format("Successfully invoked AWS Gateway API [%s %s%/s] with blank request body, receiving success response [%s] with status code [%s]", method, endpoint, resource, statusExplanation, gatewayResponse.statusCode);
            }
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Invoke AWS Gateway API").explanation(explanation).build());
        }
        catch (Exception e) {
            verificationLogger.error("Failed to invoke AWS Gateway API " + endpoint, (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Invoke AWS Gateway API").explanation(String.format("Failed to invoke AWS Gateway API [%s %s/%s]: %s", method, endpoint, resource, e.getMessage())).build());
        }
        return results;
    }

    private GatewayResponse invokeGateway(GenericApiGatewayClient client, ProcessContext context, ProcessSession session, FlowFile requestFlowFile, Map<String, String> attributes, ComponentLog logger) {
        String resourceName = context.getProperty(PROP_RESOURCE_NAME).getValue();
        GenericApiGatewayRequest request = this.configureRequest(context, session, resourceName, requestFlowFile, attributes);
        this.logRequest(logger, client.getEndpoint(), request);
        GenericApiGatewayResponse response = null;
        GenericApiGatewayException exception = null;
        try {
            response = client.execute(request);
            this.logResponse(logger, response);
        }
        catch (GenericApiGatewayException gag) {
            exception = gag;
        }
        int statusCode = exception != null ? exception.getStatusCode() : response.getHttpResponse().getStatusCode();
        if (statusCode == 0) {
            throw new IllegalStateException("Status code unknown, connection hasn't been attempted.");
        }
        return new GatewayResponse(response, exception, statusCode);
    }

    private class GatewayResponse {
        private final GenericApiGatewayResponse response;
        private final GenericApiGatewayException exception;
        private final int statusCode;

        private GatewayResponse(GenericApiGatewayResponse response, GenericApiGatewayException exception, int statusCode) {
            this.response = response;
            this.exception = exception;
            this.statusCode = statusCode;
        }
    }
}

