/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.textract;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public enum TextractType {
    DOCUMENT_ANALYSIS("Document Analysis"),
    DOCUMENT_TEXT_DETECTION("Document Text Detection"),
    EXPENSE_ANALYSIS("Expense Analysis");

    public static final Set<String> TEXTRACT_TYPES;
    public final String type;

    private TextractType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static TextractType fromString(String value) {
        return Arrays.stream(TextractType.values()).filter(type -> type.getType().equalsIgnoreCase(value)).findAny().orElseThrow(() -> new UnsupportedOperationException("Unsupported textract type."));
    }

    static {
        TEXTRACT_TYPES = Arrays.stream(TextractType.values()).map(TextractType::getType).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }
}

