/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionStrategy;

public class ClientSideCEncryptionStrategy
implements S3EncryptionStrategy {
    @Override
    public AmazonS3Client createEncryptionClient(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, String kmsRegion, String keyIdOrMaterial) {
        ValidationResult keyValidationResult = this.validateKey(keyIdOrMaterial);
        if (!keyValidationResult.isValid()) {
            throw new IllegalArgumentException("Invalid client key; " + keyValidationResult.getExplanation());
        }
        byte[] keyMaterial = Base64.decodeBase64((String)keyIdOrMaterial);
        SecretKeySpec symmetricKey = new SecretKeySpec(keyMaterial, "AES");
        StaticEncryptionMaterialsProvider encryptionMaterialsProvider = new StaticEncryptionMaterialsProvider(new EncryptionMaterials((SecretKey)symmetricKey));
        AmazonS3EncryptionClient client = new AmazonS3EncryptionClient(credentialsProvider, (EncryptionMaterialsProvider)encryptionMaterialsProvider);
        return client;
    }

    @Override
    public ValidationResult validateKey(String keyValue) {
        byte[] keyMaterial;
        if (StringUtils.isBlank((CharSequence)keyValue)) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is empty").build();
        }
        try {
            if (!Base64.isBase64((String)keyValue)) {
                throw new Exception();
            }
            keyMaterial = Base64.decodeBase64((String)keyValue);
        }
        catch (Exception e) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is not in Base64 encoded form").build();
        }
        if (keyMaterial.length != 32 && keyMaterial.length != 24 && keyMaterial.length != 16) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is not a Base64 encoded AES-256, AES-192 or AES-128 key").build();
        }
        return new ValidationResult.Builder().valid(true).build();
    }
}

