/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.sns;

import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishRequest;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.sns.AbstractSNSProcessor;
import org.apache.nifi.processors.aws.sqs.GetSQS;
import org.apache.nifi.processors.aws.sqs.PutSQS;

@SupportsBatching
@SeeAlso(value={GetSQS.class, PutSQS.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"amazon", "aws", "sns", "topic", "put", "publish", "pubsub"})
@CapabilityDescription(value="Sends the content of a FlowFile as a notification to the Amazon Simple Notification Service")
@DynamicProperty(name="A name of an attribute to be added to the notification", value="The attribute value", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="User specified dynamic Properties are added as attributes to the notification")
public class PutSNS
extends AbstractSNSProcessor {
    public static final PropertyDescriptor CHARACTER_ENCODING = new PropertyDescriptor.Builder().name("Character Set").description("The character set in which the FlowFile's content is encoded").defaultValue("UTF-8").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).required(true).build();
    public static final PropertyDescriptor USE_JSON_STRUCTURE = new PropertyDescriptor.Builder().name("Use JSON Structure").description("If true, the contents of the FlowFile must be JSON with a top-level element named 'default'. Additional elements can be used to send different messages to different protocols. See the Amazon SNS Documentation for more information.").defaultValue("false").allowableValues(new String[]{"true", "false"}).required(true).build();
    public static final PropertyDescriptor SUBJECT = new PropertyDescriptor.Builder().name("E-mail Subject").description("The optional subject to use for any subscribers that are subscribed via E-mail").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MESSAGEGROUPID = new PropertyDescriptor.Builder().name("Message Group ID").displayName("Message Group ID").description("If using FIFO, the message group to which the flowFile belongs").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor MESSAGEDEDUPLICATIONID = new PropertyDescriptor.Builder().name("Deduplication Message ID").displayName("Deduplication Message ID").description("The token used for deduplication of sent messages").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(ARN, ARN_TYPE, SUBJECT, REGION, ACCESS_KEY, SECRET_KEY, CREDENTIALS_FILE, AWS_CREDENTIALS_PROVIDER_SERVICE, TIMEOUT, USE_JSON_STRUCTURE, CHARACTER_ENCODING, PROXY_HOST, PROXY_HOST_PORT, PROXY_USERNAME, PROXY_PASSWORD, MESSAGEGROUPID, MESSAGEDEDUPLICATIONID));
    public static final int MAX_SIZE = 262144;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).dynamic(true).build();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        if (flowFile.getSize() > 262144L) {
            this.getLogger().error("Cannot publish {} to SNS because its size exceeds Amazon SNS's limit of 256KB; routing to failure", new Object[]{flowFile});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        Charset charset = Charset.forName(context.getProperty(CHARACTER_ENCODING).evaluateAttributeExpressions(flowFile).getValue());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        session.exportTo(flowFile, (OutputStream)baos);
        String message = new String(baos.toByteArray(), charset);
        AmazonSNSClient client = (AmazonSNSClient)this.getClient();
        PublishRequest request = new PublishRequest();
        request.setMessage(message);
        if (context.getProperty(MESSAGEGROUPID).isSet()) {
            request.setMessageGroupId(context.getProperty(MESSAGEGROUPID).evaluateAttributeExpressions(flowFile).getValue());
        }
        if (context.getProperty(MESSAGEDEDUPLICATIONID).isSet()) {
            request.setMessageDeduplicationId(context.getProperty(MESSAGEDEDUPLICATIONID).evaluateAttributeExpressions(flowFile).getValue());
        }
        if (context.getProperty(USE_JSON_STRUCTURE).asBoolean().booleanValue()) {
            request.setMessageStructure("json");
        }
        String arn = context.getProperty(ARN).evaluateAttributeExpressions(flowFile).getValue();
        String arnType = context.getProperty(ARN_TYPE).getValue();
        if (arnType.equalsIgnoreCase(ARN_TYPE_TOPIC.getValue())) {
            request.setTopicArn(arn);
        } else {
            request.setTargetArn(arn);
        }
        String subject = context.getProperty(SUBJECT).evaluateAttributeExpressions(flowFile).getValue();
        if (subject != null) {
            request.setSubject(subject);
        }
        for (Map.Entry entry : context.getProperties().entrySet()) {
            if (!((PropertyDescriptor)entry.getKey()).isDynamic() || StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
            MessageAttributeValue value = new MessageAttributeValue();
            value.setStringValue(context.getProperty((PropertyDescriptor)entry.getKey()).evaluateAttributeExpressions(flowFile).getValue());
            value.setDataType("String");
            request.addMessageAttributesEntry(((PropertyDescriptor)entry.getKey()).getName(), value);
        }
        try {
            client.publish(request);
            session.transfer(flowFile, REL_SUCCESS);
            session.getProvenanceReporter().send(flowFile, arn);
            this.getLogger().info("Successfully published notification for {}", new Object[]{flowFile});
        }
        catch (Exception e) {
            this.getLogger().error("Failed to publish Amazon SNS message for {} due to {}", new Object[]{flowFile, e});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

