/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.signer;

import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import org.apache.nifi.processor.exception.ProcessException;

public final class AwsCustomSignerUtil {
    private AwsCustomSignerUtil() {
    }

    public static String registerCustomSigner(String className) {
        Class<?> signerClass;
        try {
            Class<?> clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            if (!Signer.class.isAssignableFrom(clazz)) {
                throw new ProcessException(String.format("Cannot create signer from class %s because it does not implement %s", className, Signer.class.getName()));
            }
            signerClass = clazz;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ProcessException("Signer class not found: " + className);
        }
        catch (Exception e) {
            throw new ProcessException("Error while creating signer from class: " + className);
        }
        String signerName = signerClass.getName();
        SignerFactory.registerSigner((String)signerName, signerClass);
        return signerName;
    }
}

