/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processors.aws.AbstractAWSProcessor;
import org.apache.nifi.processors.aws.AwsClientDetails;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderService;

public abstract class AbstractAWSCredentialsProviderProcessor<ClientType extends AmazonWebServiceClient>
extends AbstractAWSProcessor<ClientType>
implements VerifiableProcessor {
    public static final PropertyDescriptor AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("AWS Credentials Provider service").displayName("AWS Credentials Provider Service").description("The Controller Service that is used to obtain AWS credentials provider").required(false).identifiesControllerService(AWSCredentialsProviderService.class).build();

    @Override
    public ClientType createClient(ProcessContext context, AwsClientDetails awsClientDetails) {
        ControllerService service = context.getProperty(AWS_CREDENTIALS_PROVIDER_SERVICE).asControllerService();
        if (service != null) {
            this.getLogger().debug("Using AWS credentials provider service for creating client");
            AWSCredentialsProvider credentialsProvider = this.getCredentialsProvider(context);
            ClientConfiguration configuration = this.createConfiguration(context);
            ClientType createdClient = this.createClient(context, credentialsProvider, configuration);
            this.setRegionAndInitializeEndpoint(awsClientDetails.getRegion(), context, (AmazonWebServiceClient)createdClient);
            return createdClient;
        }
        this.getLogger().debug("Using AWS credentials for creating client");
        return super.createClient(context, awsClientDetails);
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try {
            this.createClient(context);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Create Client and Configure Region").explanation("Successfully created AWS Client and configured Region").build());
        }
        catch (Exception e) {
            verificationLogger.error("Failed to create AWS Client", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Create Client and Configure Region").explanation("Failed to crete AWS Client or configure Region: " + e.getMessage()).build());
        }
        return results;
    }

    protected AWSCredentialsProvider getCredentialsProvider(ProcessContext context) {
        AWSCredentialsProviderService awsCredentialsProviderService = (AWSCredentialsProviderService)context.getProperty(AWS_CREDENTIALS_PROVIDER_SERVICE).asControllerService(AWSCredentialsProviderService.class);
        return awsCredentialsProviderService.getCredentialsProvider();
    }

    protected abstract ClientType createClient(ProcessContext var1, AWSCredentialsProvider var2, ClientConfiguration var3);
}

