/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.wag;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;
import org.apache.nifi.processors.aws.AbstractAWSProcessor;
import org.apache.nifi.processors.aws.wag.client.GenericApiGatewayClient;
import org.apache.nifi.processors.aws.wag.client.GenericApiGatewayClientBuilder;
import org.apache.nifi.processors.aws.wag.client.GenericApiGatewayRequest;
import org.apache.nifi.processors.aws.wag.client.GenericApiGatewayRequestBuilder;
import org.apache.nifi.processors.aws.wag.client.GenericApiGatewayResponse;

public abstract class AbstractAWSGatewayApiProcessor
extends AbstractAWSCredentialsProviderProcessor<GenericApiGatewayClient> {
    private volatile Set<String> dynamicPropertyNames = new HashSet<String>();
    private volatile Pattern regexAttributesToSend = null;
    private volatile AmazonHttpClient providedClient = null;
    public static final String STATUS_CODE = "aws.gateway.api.status.code";
    public static final String STATUS_MESSAGE = "aws.gateway.api.status.message";
    public static final String RESPONSE_BODY = "aws.gateway.api.response.body";
    public static final String RESOURCE_NAME_ATTR = "aws.gateway.api.resource";
    public static final String ENDPOINT_ATTR = "aws.gateway.api.endpoint";
    public static final String TRANSACTION_ID = "aws.gateway.api.tx.id";
    public static final String EXCEPTION_CLASS = "aws.gateway.api.java.exception.class";
    public static final String EXCEPTION_MESSAGE = "aws.gateway.api.java.exception.message";
    protected static final String REL_RESPONSE_NAME = "Response";
    protected static final String REL_SUCCESS_REQ_NAME = "Original";
    protected static final String REL_RETRY_NAME = "Retry";
    protected static final String REL_NO_RETRY_NAME = "No Retry";
    protected static final String REL_FAILURE_NAME = "Failure";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final Set<String> IGNORED_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("aws.gateway.api.status.code", "aws.gateway.api.status.message", "aws.gateway.api.resource", "aws.gateway.api.tx.id", "uuid", "filename", "path")));
    public static final PropertyDescriptor PROP_METHOD = new PropertyDescriptor.Builder().name("aws-gateway-http-method").displayName("HTTP Method").description("HTTP request method (GET, POST, PUT, PATCH, DELETE, HEAD, OPTIONS).Methods other than POST, PUT and PATCH will be sent without a message body.").required(true).defaultValue("GET").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).build();
    public static final PropertyDescriptor PROP_AWS_API_KEY = new PropertyDescriptor.Builder().name("aws-gateway-api-key").displayName("Amazon Gateway Api Key").description("The API Key").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROP_AWS_GATEWAY_API_ENDPOINT = new PropertyDescriptor.Builder().name("aws-gateway-api-endpoint").displayName("Amazon Gateway Api Endpoint").description("The Api Endpoint").required(true).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor PROP_AWS_GATEWAY_API_REGION = new PropertyDescriptor.Builder().name("aws-gateway-region").displayName("Amazon Region").required(true).allowableValues(AbstractAWSProcessor.getAvailableRegions()).defaultValue(AbstractAWSProcessor.createAllowableValue(Regions.DEFAULT_REGION).getValue()).build();
    public static final PropertyDescriptor PROP_RESOURCE_NAME = new PropertyDescriptor.Builder().name("aws-gateway-resource").displayName("Amazon Gateway Api ResourceName").description("The Name of the Gateway API Resource").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROP_QUERY_PARAMS = new PropertyDescriptor.Builder().name("aws-gateway-query-parameters").displayName("Query Parameters").description("The query parameters for this request in the form of Name=Value separated by &").displayName("Query Parameters").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).build();
    public static final PropertyDescriptor PROP_ATTRIBUTES_TO_SEND = new PropertyDescriptor.Builder().name("aws-gateway-attributes-to-send").displayName("Attributes to Send").description("Regular expression that defines which attributes to send as HTTP headers in the request. If not defined, no attributes are sent as headers. Also any dynamic properties set will be sent as headers. The dynamic property key will be the header key and the dynamic property value will be interpreted as expression language will be the header value.").required(false).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor PROP_PUT_OUTPUT_IN_ATTRIBUTE = new PropertyDescriptor.Builder().name("aws-gateway-put-response-body-in-attribute").displayName("Put Response Body In Attribute").description("If set, the response body received back will be put into an attribute of the original FlowFile instead of a separate FlowFile. The attribute key to put to is determined by evaluating value of this property. ").addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor PROP_OUTPUT_RESPONSE_REGARDLESS = new PropertyDescriptor.Builder().name("aws-gateway-always-output-response").displayName("Always Output Response").description("Will force a response FlowFile to be generated and routed to the 'Response' relationship regardless of what the server status code received is or if the processor is configured to put the server response body in the request attribute. In the later configuration a request FlowFile with the response body in the attribute and a typical response FlowFile will be emitted to their respective relationships.").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor PROP_PENALIZE_NO_RETRY = new PropertyDescriptor.Builder().name("aws-gateway-penalize-no-retry").displayName("Penalize on \"No Retry\"").description("Enabling this property will penalize FlowFiles that are routed to the \"No Retry\" relationship.").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor PROP_PUT_ATTRIBUTE_MAX_LENGTH = new PropertyDescriptor.Builder().name("aws-gateway-max-attribute-length").displayName("Max Length To Put In Attribute").description("If routing the response body to an attribute of the original (by setting the \"Put response body in attribute\" property or by receiving an error status code), the number of characters put to the attribute value will be at most this amount. This is important because attributes are held in memory and large attributes will quickly cause out of memory issues. If the output goes longer than this value, it will be truncated to fit. Consider making this smaller if able.").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("256").build();
    public static final PropertyDescriptor PROP_CONTENT_TYPE = new PropertyDescriptor.Builder().name("aws-gateway-content-type").displayName("Content-Type").description("The Content-Type to specify for when content is being transmitted through a PUT, POST or PATCH. In the case of an empty value after evaluating an expression language expression, Content-Type defaults to application/octet-stream").required(true).expressionLanguageSupported(true).defaultValue("${" + CoreAttributes.MIME_TYPE.key() + "}").addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).build();
    public static final PropertyDescriptor PROP_SEND_BODY = new PropertyDescriptor.Builder().name("aws-gateway-send-message-body").displayName("Send Message Body").description("If true, sends the HTTP message body on POST/PUT/PATCH requests (default).  If false, suppresses the message body and content-type header for these requests.").defaultValue("true").allowableValues(new String[]{"true", "false"}).required(false).build();
    public static final PropertyDescriptor PROP_ADD_HEADERS_TO_REQUEST = new PropertyDescriptor.Builder().name("aws-gateway-add-response-headers-request").displayName("Add Response Headers To Request").description("Enabling this property saves all the response headers to the original request. This may be when the response headers are needed but a response is not generated due to the status code received.").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor PROP_CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("aws-gateway-connection-timeout").displayName("Connection Timeout").description("Max wait time for connection to remote service.").required(false).defaultValue("10 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor PROP_READ_TIMEOUT = new PropertyDescriptor.Builder().name("aws-gateway-read-timeout").displayName("Read Timeout").description("Max wait time for response from remote service.").required(false).defaultValue("50 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();

    public AbstractAWSGatewayApiProcessor() {
    }

    public AbstractAWSGatewayApiProcessor(AmazonHttpClient client) {
        this.providedClient = client;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().required(false).name(propertyDescriptorName).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.isDynamic()) {
            HashSet<String> newDynamicPropertyNames = new HashSet<String>(this.dynamicPropertyNames);
            if (newValue == null) {
                newDynamicPropertyNames.remove(descriptor.getName());
            } else if (oldValue == null) {
                newDynamicPropertyNames.add(descriptor.getName());
            }
            this.dynamicPropertyNames = Collections.unmodifiableSet(newDynamicPropertyNames);
        } else if (PROP_ATTRIBUTES_TO_SEND.getName().equalsIgnoreCase(descriptor.getName())) {
            if (newValue == null || newValue.isEmpty()) {
                this.regexAttributesToSend = null;
            } else {
                String trimmedValue = StringUtils.trimToEmpty((String)newValue);
                this.regexAttributesToSend = Pattern.compile(trimmedValue);
            }
        }
    }

    @Override
    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(3);
        results.addAll(super.customValidate(validationContext));
        boolean querySet = validationContext.getProperty(PROP_QUERY_PARAMS).isSet();
        if (querySet) {
            String input = validationContext.getProperty(PROP_QUERY_PARAMS).getValue();
            if (!validationContext.isExpressionLanguageSupported(PROP_QUERY_PARAMS.getName()) || !validationContext.isExpressionLanguagePresent(input)) {
                try {
                    String evaluatedInput = validationContext.newPropertyValue(input).evaluateAttributeExpressions().getValue();
                    String encodedInput = URLEncoder.encode(evaluatedInput, "UTF-8");
                    String url = String.format("http://www.foo.com?%s", encodedInput);
                    new URL(url);
                    results.add(new ValidationResult.Builder().subject(PROP_QUERY_PARAMS.getName()).input(input).explanation("Valid URL params").valid(true).build());
                }
                catch (Exception e) {
                    results.add(new ValidationResult.Builder().subject(PROP_QUERY_PARAMS.getName()).input(input).explanation("Not a valid set of URL params").valid(false).build());
                }
            }
        }
        String method = StringUtils.trimToEmpty((String)validationContext.getProperty(PROP_METHOD).getValue()).toUpperCase();
        if (!validationContext.isExpressionLanguageSupported(PROP_METHOD.getName()) || !validationContext.isExpressionLanguagePresent(method)) {
            try {
                HttpMethodName.fromValue((String)method);
            }
            catch (IllegalArgumentException e) {
                results.add(new ValidationResult.Builder().subject(PROP_METHOD.getName()).input(method).explanation("Unsupported METHOD").valid(false).build());
            }
        }
        return results;
    }

    @Override
    protected GenericApiGatewayClient createClient(ProcessContext context, AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        GenericApiGatewayClientBuilder builder = new GenericApiGatewayClientBuilder().withCredentials(awsCredentialsProvider).withClientConfiguration(clientConfiguration).withEndpoint(context.getProperty(PROP_AWS_GATEWAY_API_ENDPOINT).getValue()).withRegion(Region.getRegion((Regions)Regions.fromName((String)context.getProperty(PROP_AWS_GATEWAY_API_REGION).getValue())));
        if (context.getProperty(PROP_AWS_API_KEY).isSet()) {
            builder = builder.withApiKey(context.getProperty(PROP_AWS_API_KEY).evaluateAttributeExpressions().getValue());
        }
        if (this.providedClient != null) {
            builder = builder.withHttpClient(this.providedClient);
        }
        return builder.build();
    }

    @Override
    @Deprecated
    protected GenericApiGatewayClient createClient(ProcessContext context, AWSCredentials credentials, ClientConfiguration clientConfiguration) {
        return this.createClient(context, (AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentials), clientConfiguration);
    }

    protected GenericApiGatewayRequest configureRequest(ProcessContext context, ProcessSession session, String resourcePath, FlowFile requestFlowFile, Map<String, String> attributes) {
        String method = StringUtils.trimToEmpty((String)context.getProperty(PROP_METHOD).evaluateAttributeExpressions(requestFlowFile).getValue()).toUpperCase();
        HttpMethodName methodName = HttpMethodName.fromValue((String)method);
        return this.configureRequest(context, session, resourcePath, requestFlowFile, methodName, attributes);
    }

    protected GenericApiGatewayRequest configureRequest(ProcessContext context, ProcessSession session, String resourcePath, FlowFile requestFlowFile, HttpMethodName methodName, Map<String, String> attributes) {
        GenericApiGatewayRequestBuilder builder = new GenericApiGatewayRequestBuilder().withResourcePath(resourcePath);
        Map<String, List<String>> parameters = this.getParameters(context, attributes);
        builder = builder.withParameters(parameters);
        switch (methodName) {
            case GET: {
                builder = builder.withHttpMethod(HttpMethodName.GET);
                break;
            }
            case POST: {
                InputStream requestBody = this.getRequestBodyToSend(session, context, requestFlowFile);
                builder = builder.withHttpMethod(HttpMethodName.POST).withBody(requestBody);
                break;
            }
            case PUT: {
                InputStream requestBody = this.getRequestBodyToSend(session, context, requestFlowFile);
                builder = builder.withHttpMethod(HttpMethodName.PUT).withBody(requestBody);
                break;
            }
            case PATCH: {
                InputStream requestBody = this.getRequestBodyToSend(session, context, requestFlowFile);
                builder = builder.withHttpMethod(HttpMethodName.PATCH).withBody(requestBody);
                break;
            }
            case HEAD: {
                builder = builder.withHttpMethod(HttpMethodName.HEAD);
                break;
            }
            case DELETE: {
                builder = builder.withHttpMethod(HttpMethodName.DELETE);
                break;
            }
            case OPTIONS: {
                InputStream requestBody = this.getRequestBodyToSend(session, context, requestFlowFile);
                builder = builder.withHttpMethod(HttpMethodName.OPTIONS).withBody(requestBody);
            }
        }
        builder = this.setHeaderProperties(context, builder, methodName, attributes);
        return builder.build();
    }

    protected InputStream getRequestBodyToSend(ProcessSession session, ProcessContext context, FlowFile requestFlowFile) {
        if (context.getProperty(PROP_SEND_BODY).asBoolean().booleanValue() && requestFlowFile != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            session.exportTo(requestFlowFile, (OutputStream)outputStream);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    protected GenericApiGatewayRequestBuilder setHeaderProperties(ProcessContext context, GenericApiGatewayRequestBuilder requestBuilder, HttpMethodName methodName, Map<String, String> requestAttributes) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String string : this.dynamicPropertyNames) {
            String string2 = context.getProperty(string).evaluateAttributeExpressions(requestAttributes).getValue();
            headers.put(string, string2);
        }
        if (this.regexAttributesToSend != null) {
            Matcher m = this.regexAttributesToSend.matcher("");
            for (Map.Entry<String, String> entry : requestAttributes.entrySet()) {
                String headerKey = StringUtils.trimToEmpty((String)entry.getKey());
                if (IGNORED_ATTRIBUTES.contains(headerKey)) continue;
                m.reset(headerKey);
                if (!m.matches()) continue;
                String headerVal = StringUtils.trimToEmpty((String)entry.getValue());
                headers.put(headerKey, headerVal);
            }
        }
        String contentType = context.getProperty(PROP_CONTENT_TYPE).evaluateAttributeExpressions(requestAttributes).getValue();
        boolean bl = context.getProperty(PROP_SEND_BODY).asBoolean();
        String string = contentType = StringUtils.isBlank((CharSequence)contentType) ? DEFAULT_CONTENT_TYPE : contentType;
        if (methodName == HttpMethodName.PUT || methodName == HttpMethodName.POST || methodName == HttpMethodName.PATCH) {
            if (bl) {
                headers.put("Content-Type", contentType);
            }
        } else {
            headers.put("Content-Type", contentType);
        }
        if (!headers.isEmpty()) {
            requestBuilder = requestBuilder.withHeaders(headers);
        }
        return requestBuilder;
    }

    protected Map<String, List<String>> getParameters(ProcessContext context, Map<String, String> flowFileAttributes) {
        if (!context.getProperty(PROP_QUERY_PARAMS).isSet()) {
            return new HashMap<String, List<String>>();
        }
        String queryString = context.getProperty(PROP_QUERY_PARAMS).evaluateAttributeExpressions(flowFileAttributes).getValue();
        List params = URLEncodedUtils.parse((String)queryString, (Charset)Charsets.toCharset((String)"UTF-8"));
        if (params.isEmpty()) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (NameValuePair nvp : params) {
            if (!map.containsKey(nvp.getName())) {
                map.put(nvp.getName(), new ArrayList());
            }
            ((List)map.get(nvp.getName())).add(nvp.getValue());
        }
        return map;
    }

    protected Map<String, String> convertAttributesFromHeaders(GenericApiGatewayResponse responseHttp) {
        HashMap<String, String> map = new HashMap<String, String>();
        responseHttp.getHttpResponse().getHeaders().entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key == null) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)value)) {
                return;
            }
            map.put(key, value);
        });
        return map;
    }

    protected Relationship getRelationshipForName(String name, Set<Relationship> relationships) {
        for (Relationship relationship : relationships) {
            if (!relationship.getName().equals(name)) continue;
            return relationship;
        }
        throw new IllegalStateException("Unknown relationship " + name);
    }

    protected void route(FlowFile request, FlowFile response, ProcessSession session, ProcessContext context, int statusCode, Set<Relationship> relationships) {
        if (!this.isSuccess(statusCode) && request == null) {
            context.yield();
        }
        boolean responseSent = false;
        if (context.getProperty(PROP_OUTPUT_RESPONSE_REGARDLESS).asBoolean().booleanValue()) {
            session.transfer(response, this.getRelationshipForName(REL_RESPONSE_NAME, relationships));
            responseSent = true;
        }
        if (this.isSuccess(statusCode)) {
            if (request != null) {
                session.transfer(request, this.getRelationshipForName(REL_SUCCESS_REQ_NAME, relationships));
            }
            if (response != null && !responseSent) {
                session.transfer(response, this.getRelationshipForName(REL_RESPONSE_NAME, relationships));
            }
        } else if (statusCode / 100 == 5) {
            if (request != null) {
                request = session.penalize(request);
                session.transfer(request, this.getRelationshipForName(REL_RETRY_NAME, relationships));
            }
        } else if (request != null) {
            if (context.getProperty(PROP_PENALIZE_NO_RETRY).asBoolean().booleanValue()) {
                request = session.penalize(request);
            }
            session.transfer(request, this.getRelationshipForName(REL_NO_RETRY_NAME, relationships));
        }
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode / 100 == 2;
    }

    protected void logRequest(ComponentLog logger, URI endpoint, GenericApiGatewayRequest request) {
        try {
            logger.debug("\nRequest to remote service:\n\t{}\t{}\t\n{}", new Object[]{endpoint.toURL().toExternalForm(), request.getHttpMethod(), this.getLogString(request.getHeaders())});
        }
        catch (MalformedURLException e) {
            logger.debug(e.getMessage());
        }
    }

    protected void logResponse(ComponentLog logger, GenericApiGatewayResponse response) {
        try {
            logger.debug("\nResponse from remote service:\n\t{}\n{}", new Object[]{response.getHttpResponse().getHttpRequest().getURI().toURL().toExternalForm(), this.getLogString(response.getHttpResponse().getHeaders())});
        }
        catch (MalformedURLException e) {
            logger.debug(e.getMessage());
        }
    }

    protected String getLogString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String value = entry.getValue();
                sb.append("\t");
                sb.append(entry.getKey());
                sb.append(": ");
                sb.append(value);
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

