/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis.stream;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.kinesis.AbstractBaseKinesisProcessor;

public abstract class AbstractKinesisStreamProcessor
extends AbstractBaseKinesisProcessor<AmazonKinesisClient> {
    public static final PropertyDescriptor KINESIS_STREAM_NAME = new PropertyDescriptor.Builder().name("kinesis-stream-name").displayName("Amazon Kinesis Stream Name").description("The name of Kinesis Stream").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();

    @Override
    protected AmazonKinesisClient createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        this.getLogger().info("Creating client using aws credentials provider");
        return new AmazonKinesisClient(credentialsProvider, config);
    }

    @Override
    protected AmazonKinesisClient createClient(ProcessContext context, AWSCredentials credentials, ClientConfiguration config) {
        this.getLogger().info("Creating client using aws credentials");
        return this.createClient(context, (AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentials), config);
    }
}

