/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ConfigurableAccessPolicyProvider;
import org.apache.nifi.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.authorization.User;

public final class AuthorizerCapabilityDetection {
    public static boolean isManagedAuthorizer(Authorizer authorizer) {
        return authorizer instanceof ManagedAuthorizer;
    }

    public static boolean isConfigurableAccessPolicyProvider(Authorizer authorizer) {
        if (!AuthorizerCapabilityDetection.isManagedAuthorizer(authorizer)) {
            return false;
        }
        ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
        return managedAuthorizer.getAccessPolicyProvider() instanceof ConfigurableAccessPolicyProvider;
    }

    public static boolean isConfigurableUserGroupProvider(Authorizer authorizer) {
        if (!AuthorizerCapabilityDetection.isManagedAuthorizer(authorizer)) {
            return false;
        }
        ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
        AccessPolicyProvider accessPolicyProvider = managedAuthorizer.getAccessPolicyProvider();
        return accessPolicyProvider.getUserGroupProvider() instanceof ConfigurableUserGroupProvider;
    }

    public static boolean isUserConfigurable(Authorizer authorizer, User user) {
        if (!AuthorizerCapabilityDetection.isConfigurableUserGroupProvider(authorizer)) {
            return false;
        }
        ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
        ConfigurableUserGroupProvider configurableUserGroupProvider = (ConfigurableUserGroupProvider)managedAuthorizer.getAccessPolicyProvider().getUserGroupProvider();
        return configurableUserGroupProvider.isConfigurable(user);
    }

    public static boolean isGroupConfigurable(Authorizer authorizer, Group group) {
        if (!AuthorizerCapabilityDetection.isConfigurableUserGroupProvider(authorizer)) {
            return false;
        }
        ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
        ConfigurableUserGroupProvider configurableUserGroupProvider = (ConfigurableUserGroupProvider)managedAuthorizer.getAccessPolicyProvider().getUserGroupProvider();
        return configurableUserGroupProvider.isConfigurable(group);
    }

    public static boolean isAccessPolicyConfigurable(Authorizer authorizer, AccessPolicy accessPolicy) {
        if (!AuthorizerCapabilityDetection.isConfigurableAccessPolicyProvider(authorizer)) {
            return false;
        }
        ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
        ConfigurableAccessPolicyProvider configurableAccessPolicyProvider = (ConfigurableAccessPolicyProvider)managedAuthorizer.getAccessPolicyProvider();
        return configurableAccessPolicyProvider.isConfigurable(accessPolicy);
    }

    private AuthorizerCapabilityDetection() {
    }
}

