/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.asana;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.http.entity.ContentType;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.asana.AsanaClient;
import org.apache.nifi.controller.asana.AsanaClientProviderService;
import org.apache.nifi.distributed.cache.client.DistributedMapCacheClient;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.asana.AsanaObjectType;
import org.apache.nifi.processors.asana.GenericObjectSerDe;
import org.apache.nifi.processors.asana.utils.AsanaObject;
import org.apache.nifi.processors.asana.utils.AsanaObjectFetcher;
import org.apache.nifi.processors.asana.utils.AsanaObjectState;
import org.apache.nifi.processors.asana.utils.AsanaProjectEventFetcher;
import org.apache.nifi.processors.asana.utils.AsanaProjectFetcher;
import org.apache.nifi.processors.asana.utils.AsanaProjectMembershipFetcher;
import org.apache.nifi.processors.asana.utils.AsanaProjectStatusAttachmentFetcher;
import org.apache.nifi.processors.asana.utils.AsanaProjectStatusFetcher;
import org.apache.nifi.processors.asana.utils.AsanaStoryFetcher;
import org.apache.nifi.processors.asana.utils.AsanaTagFetcher;
import org.apache.nifi.processors.asana.utils.AsanaTaskAttachmentFetcher;
import org.apache.nifi.processors.asana.utils.AsanaTaskFetcher;
import org.apache.nifi.processors.asana.utils.AsanaTeamFetcher;
import org.apache.nifi.processors.asana.utils.AsanaTeamMemberFetcher;
import org.apache.nifi.processors.asana.utils.AsanaUserFetcher;
import org.apache.nifi.reporting.InitializationException;

@TriggerSerially
@PrimaryNodeOnly
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@WritesAttribute(attribute="asana.gid", description="Global ID of the object in Asana.")
@Tags(value={"asana", "source", "ingest"})
@CapabilityDescription(value="This processor collects data from Asana")
@SystemResourceConsideration(resource=SystemResource.MEMORY)
public class GetAsanaObject
extends AbstractProcessor {
    protected static final String ASANA_GID = "asana.gid";
    protected static final String ASANA_CLIENT_SERVICE = "asana-controller-service";
    protected static final String DISTRIBUTED_CACHE_SERVICE = "distributed-cache-service";
    protected static final String ASANA_OBJECT_TYPE = "asana-object-type";
    protected static final String ASANA_PROJECT_NAME = "asana-project-name";
    protected static final String ASANA_SECTION_NAME = "asana-section-name";
    protected static final String ASANA_TAG_NAME = "asana-tag-name";
    protected static final String ASANA_TEAM_NAME = "asana-team-name";
    protected static final String ASANA_OUTPUT_BATCH_SIZE = "asana-output-batch-size";
    protected static final String REL_NAME_NEW = "new";
    protected static final String REL_NAME_UPDATED = "updated";
    protected static final String REL_NAME_REMOVED = "removed";
    protected static final PropertyDescriptor PROP_ASANA_CLIENT_SERVICE = new PropertyDescriptor.Builder().name("asana-controller-service").displayName("Asana Client Service").description("Specify which controller service to use for accessing Asana.").required(true).identifiesControllerService(AsanaClientProviderService.class).build();
    protected static final PropertyDescriptor PROP_DISTRIBUTED_CACHE_SERVICE = new PropertyDescriptor.Builder().name("distributed-cache-service").displayName("Distributed Cache Service").description("Cache service to store fetched item fingerprints. These, from the last successful query are stored, in order to enable incremental loading and change detection.").required(true).identifiesControllerService(DistributedMapCacheClient.class).build();
    protected static final PropertyDescriptor PROP_ASANA_OBJECT_TYPE = new PropertyDescriptor.Builder().name("asana-object-type").displayName("Object Type").description("Specify what kind of objects to be collected from Asana").required(true).allowableValues(AsanaObjectType.class).defaultValue(AsanaObjectType.AV_COLLECT_TASKS.getValue()).build();
    protected static final PropertyDescriptor PROP_ASANA_PROJECT = new PropertyDescriptor.Builder().name("asana-project-name").displayName("Project Name").description("Fetch only objects in this project. Case sensitive.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(PROP_ASANA_OBJECT_TYPE, (DescribedValue)AsanaObjectType.AV_COLLECT_TASKS, new DescribedValue[]{AsanaObjectType.AV_COLLECT_TASK_ATTACHMENTS, AsanaObjectType.AV_COLLECT_PROJECT_MEMBERS, AsanaObjectType.AV_COLLECT_STORIES, AsanaObjectType.AV_COLLECT_PROJECT_STATUS_UPDATES, AsanaObjectType.AV_COLLECT_PROJECT_STATUS_ATTACHMENTS, AsanaObjectType.AV_COLLECT_PROJECT_EVENTS}).build();
    protected static final PropertyDescriptor PROP_ASANA_SECTION = new PropertyDescriptor.Builder().name("asana-section-name").displayName("Section Name").description("Fetch only objects in this section. Case sensitive.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(PROP_ASANA_OBJECT_TYPE, (DescribedValue)AsanaObjectType.AV_COLLECT_TASKS, new DescribedValue[]{AsanaObjectType.AV_COLLECT_TASK_ATTACHMENTS, AsanaObjectType.AV_COLLECT_STORIES}).build();
    protected static final PropertyDescriptor PROP_ASANA_TAG = new PropertyDescriptor.Builder().name("asana-tag-name").displayName("Tag").description("Fetch only objects having this tag. Case sensitive.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(PROP_ASANA_OBJECT_TYPE, (DescribedValue)AsanaObjectType.AV_COLLECT_TASKS, new DescribedValue[]{AsanaObjectType.AV_COLLECT_TASK_ATTACHMENTS, AsanaObjectType.AV_COLLECT_STORIES}).build();
    protected static final PropertyDescriptor PROP_ASANA_TEAM_NAME = new PropertyDescriptor.Builder().name("asana-team-name").displayName("Team").description("Team name. Case sensitive.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(PROP_ASANA_OBJECT_TYPE, (DescribedValue)AsanaObjectType.AV_COLLECT_TEAM_MEMBERS, new DescribedValue[0]).build();
    protected static final PropertyDescriptor PROP_ASANA_OUTPUT_BATCH_SIZE = new PropertyDescriptor.Builder().name("asana-output-batch-size").displayName("Output Batch Size").description("The number of items batched together in a single Flow File. If set to 1 (default), then each item is transferred in a separate Flow File and each will have an asana.gid attribute, to help identifying the fetched item on the server side, if needed. If the batch size is greater than 1, then the specified amount of items are batched together in a single Flow File as a Json array, and the Flow Files won't have the asana.gid attribute.").defaultValue("1").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    protected static final List<PropertyDescriptor> DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(PROP_ASANA_CLIENT_SERVICE, PROP_DISTRIBUTED_CACHE_SERVICE, PROP_ASANA_OBJECT_TYPE, PROP_ASANA_PROJECT, PROP_ASANA_SECTION, PROP_ASANA_TEAM_NAME, PROP_ASANA_TAG, PROP_ASANA_OUTPUT_BATCH_SIZE));
    protected static final Relationship REL_NEW = new Relationship.Builder().name("new").description("Newly collected objects are routed to this relationship.").build();
    protected static final Relationship REL_UPDATED = new Relationship.Builder().name("updated").description("Objects that have already been collected earlier, but were updated since, are routed to this relationship.").build();
    protected static final Relationship REL_REMOVED = new Relationship.Builder().name("removed").description("Notification about deleted objects are routed to this relationship. Flow files will not have any payload. IDs of the resources no longer exist are carried by the asana.gid attribute of the generated FlowFiles.").build();
    protected static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_NEW, REL_UPDATED, REL_REMOVED)));
    protected static final GenericObjectSerDe<String> STATE_MAP_KEY_SERIALIZER = new GenericObjectSerDe();
    protected static final GenericObjectSerDe<Map<String, String>> STATE_MAP_VALUE_SERIALIZER = new GenericObjectSerDe();
    private volatile AsanaObjectFetcher objectFetcher;
    private volatile Integer batchSize;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws InitializationException {
        AsanaClientProviderService controllerService = (AsanaClientProviderService)context.getProperty(PROP_ASANA_CLIENT_SERVICE).asControllerService(AsanaClientProviderService.class);
        AsanaClient client = controllerService.createClient();
        this.batchSize = context.getProperty(PROP_ASANA_OUTPUT_BATCH_SIZE).asInteger();
        try {
            this.getLogger().debug("Initializing object fetcher...");
            this.objectFetcher = this.createObjectFetcher(context, client);
        }
        catch (Exception e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        Map<String, String> processorState = this.recoverState(context).orElse(Collections.emptyMap());
        try {
            this.getLogger().debug("Attempting to load state: {}", new Object[]{processorState});
            this.objectFetcher.loadState(processorState);
        }
        catch (Exception e) {
            this.getLogger().info("Failed to recover state. Falling back to clean start.");
            this.objectFetcher.clearState();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Initial state: {}", new Object[]{this.objectFetcher.saveState()});
        }
        int transferCount = 0;
        if (this.batchSize == 1) {
            AsanaObject asanaObject;
            while ((asanaObject = this.objectFetcher.fetchNext()) != null) {
                HashMap<String, String> attributes = new HashMap<String, String>(2);
                attributes.put(CoreAttributes.MIME_TYPE.key(), ContentType.APPLICATION_JSON.getMimeType());
                attributes.put(ASANA_GID, asanaObject.getGid());
                FlowFile flowFile = this.createFlowFileWithStringPayload(session, asanaObject.getContent());
                flowFile = session.putAllAttributes(flowFile, attributes);
                GetAsanaObject.transferFlowFileByAsanaObjectState(session, asanaObject.getState(), flowFile);
                ++transferCount;
            }
        } else {
            AsanaObject asanaObject;
            HashMap flowFileContents = new HashMap();
            flowFileContents.put(AsanaObjectState.NEW, new ArrayList());
            flowFileContents.put(AsanaObjectState.UPDATED, new ArrayList());
            flowFileContents.put(AsanaObjectState.REMOVED, new ArrayList());
            while ((asanaObject = this.objectFetcher.fetchNext()) != null) {
                AsanaObjectState state = asanaObject.getState();
                Collection buffer = (Collection)flowFileContents.get((Object)state);
                buffer.add(asanaObject.getContent());
                if (buffer.size() != this.batchSize.intValue()) continue;
                this.transferBatchedItemsFromBuffer(session, state, buffer);
                ++transferCount;
                buffer.clear();
            }
            for (Map.Entry entry : flowFileContents.entrySet()) {
                if (((Collection)entry.getValue()).isEmpty()) continue;
                this.transferBatchedItemsFromBuffer(session, (AsanaObjectState)((Object)entry.getKey()), (Collection)entry.getValue());
                ++transferCount;
            }
        }
        if (transferCount == 0) {
            context.yield();
            this.getLogger().debug("Yielding, as there are no new FlowFiles.");
        }
        session.commitAsync();
        Map<String, String> state = this.objectFetcher.saveState();
        this.persistState(state, context);
        this.objectFetcher.clearState();
        this.getLogger().debug("New state after transferring {} FlowFiles: {}", new Object[]{transferCount, state});
    }

    private void transferBatchedItemsFromBuffer(ProcessSession session, AsanaObjectState state, Collection<String> buffer) {
        FlowFile flowFile = this.createFlowFileWithStringPayload(session, String.format("[%s]", String.join((CharSequence)",", buffer)));
        flowFile = session.putAllAttributes(flowFile, Collections.singletonMap(CoreAttributes.MIME_TYPE.key(), ContentType.APPLICATION_JSON.getMimeType()));
        GetAsanaObject.transferFlowFileByAsanaObjectState(session, state, flowFile);
    }

    private static void transferFlowFileByAsanaObjectState(ProcessSession session, AsanaObjectState state, FlowFile flowFile) {
        switch (state) {
            case NEW: {
                session.transfer(flowFile, REL_NEW);
                break;
            }
            case UPDATED: {
                session.transfer(flowFile, REL_UPDATED);
                break;
            }
            case REMOVED: {
                session.transfer(flowFile, REL_REMOVED);
            }
        }
    }

    protected AsanaObjectFetcher createObjectFetcher(ProcessContext context, AsanaClient client) {
        String objectType = context.getProperty(PROP_ASANA_OBJECT_TYPE).getValue();
        String projectName = context.getProperty(PROP_ASANA_PROJECT).getValue();
        String sectionName = context.getProperty(PROP_ASANA_SECTION).getValue();
        String teamName = context.getProperty(PROP_ASANA_TEAM_NAME).getValue();
        String tagName = context.getProperty(PROP_ASANA_TAG).getValue();
        switch (AsanaObjectType.fromValue(objectType)) {
            case AV_COLLECT_TASKS: {
                return new AsanaTaskFetcher(client, projectName, sectionName, tagName);
            }
            case AV_COLLECT_PROJECTS: {
                return new AsanaProjectFetcher(client);
            }
            case AV_COLLECT_PROJECT_EVENTS: {
                return new AsanaProjectEventFetcher(client, projectName);
            }
            case AV_COLLECT_PROJECT_MEMBERS: {
                return new AsanaProjectMembershipFetcher(client, projectName);
            }
            case AV_COLLECT_PROJECT_STATUS_ATTACHMENTS: {
                return new AsanaProjectStatusAttachmentFetcher(client, projectName);
            }
            case AV_COLLECT_PROJECT_STATUS_UPDATES: {
                return new AsanaProjectStatusFetcher(client, projectName);
            }
            case AV_COLLECT_STORIES: {
                return new AsanaStoryFetcher(client, projectName, sectionName, tagName);
            }
            case AV_COLLECT_TAGS: {
                return new AsanaTagFetcher(client);
            }
            case AV_COLLECT_TASK_ATTACHMENTS: {
                return new AsanaTaskAttachmentFetcher(client, projectName, sectionName, tagName);
            }
            case AV_COLLECT_TEAMS: {
                return new AsanaTeamFetcher(client);
            }
            case AV_COLLECT_TEAM_MEMBERS: {
                return new AsanaTeamMemberFetcher(client, teamName);
            }
            case AV_COLLECT_USERS: {
                return new AsanaUserFetcher(client);
            }
        }
        throw new ProcessException("Cannot fetch objects of type: " + objectType);
    }

    private Optional<Map<String, String>> recoverState(ProcessContext context) {
        DistributedMapCacheClient client = GetAsanaObject.getDistributedMapCacheClient(context);
        try {
            Map result = (Map)client.get((Object)this.getIdentifier(), STATE_MAP_KEY_SERIALIZER, STATE_MAP_VALUE_SERIALIZER);
            return Optional.ofNullable(result);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private FlowFile createFlowFileWithStringPayload(ProcessSession session, String payload) {
        byte[] data = payload.getBytes(StandardCharsets.UTF_8);
        return session.importFrom((InputStream)new ByteArrayInputStream(data), session.create());
    }

    private void persistState(Map<String, String> state, ProcessContext context) {
        DistributedMapCacheClient client = GetAsanaObject.getDistributedMapCacheClient(context);
        try {
            client.put((Object)this.getIdentifier(), state, STATE_MAP_KEY_SERIALIZER, STATE_MAP_VALUE_SERIALIZER);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static DistributedMapCacheClient getDistributedMapCacheClient(ProcessContext context) {
        return (DistributedMapCacheClient)context.getProperty(DISTRIBUTED_CACHE_SERVICE).asControllerService(DistributedMapCacheClient.class);
    }
}

