/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.asana.utils;

import com.asana.models.Story;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.nifi.controller.asana.AsanaClient;
import org.apache.nifi.processors.asana.utils.AsanaTaskFetcher;
import org.apache.nifi.processors.asana.utils.GenericAsanaObjectFetcher;

public class AsanaStoryFetcher
extends GenericAsanaObjectFetcher<Story> {
    private final AsanaClient client;
    private final AsanaTaskFetcher taskFetcher;

    public AsanaStoryFetcher(AsanaClient client, String projectName, String sectionName, String tagName) {
        this.client = client;
        this.taskFetcher = new AsanaTaskFetcher(client, projectName, sectionName, tagName);
    }

    @Override
    public Map<String, String> saveState() {
        HashMap<String, String> state = new HashMap<String, String>();
        state.putAll(this.taskFetcher.saveState());
        state.putAll(super.saveState());
        return state;
    }

    @Override
    public void loadState(Map<String, String> state) {
        this.taskFetcher.loadState(state);
        super.loadState(state);
    }

    @Override
    protected Stream<Story> fetchObjects() {
        return this.fetchStories();
    }

    private Stream<Story> fetchStories() {
        return this.taskFetcher.fetchTasks().flatMap(arg_0 -> ((AsanaClient)this.client).getStories(arg_0));
    }
}

