/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDependency;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceDefinition;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.components.resource.StandardResourceDefinition;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.expression.ExpressionLanguageScope;

public final class PropertyDescriptor
implements Comparable<PropertyDescriptor> {
    public static final PropertyDescriptor NULL_DESCRIPTOR = new Builder().name("").build();
    private final String name;
    private final String displayName;
    private final String description;
    private final String defaultValue;
    private final List<AllowableValue> allowableValues;
    private final boolean required;
    private final boolean sensitive;
    private final boolean dynamic;
    @Deprecated
    private final boolean expressionLanguageSupported;
    private final ExpressionLanguageScope expressionLanguageScope;
    private final boolean dynamicallyModifiesClasspath;
    private final Class<? extends ControllerService> controllerServiceDefinition;
    private final List<Validator> validators;
    private final Set<PropertyDependency> dependencies;
    private final ResourceDefinition resourceDefinition;

    protected PropertyDescriptor(Builder builder) {
        this.displayName = builder.displayName == null ? builder.name : builder.displayName;
        this.name = builder.name;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
        this.allowableValues = builder.allowableValues == null ? null : Collections.unmodifiableList(new ArrayList<AllowableValue>(builder.allowableValues));
        this.required = builder.required;
        this.sensitive = builder.sensitive;
        this.dynamic = builder.dynamic;
        this.dynamicallyModifiesClasspath = builder.dynamicallyModifiesClasspath;
        this.expressionLanguageSupported = builder.expressionLanguageSupported;
        this.expressionLanguageScope = builder.expressionLanguageScope;
        this.controllerServiceDefinition = builder.controllerServiceDefinition;
        this.validators = Collections.unmodifiableList(new ArrayList<Validator>(builder.validators));
        this.dependencies = builder.dependencies == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<PropertyDependency>(builder.dependencies));
        this.resourceDefinition = builder.resourceDefinition;
    }

    @Override
    public int compareTo(PropertyDescriptor o) {
        if (o == null) {
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }

    public ValidationResult validate(String input, ValidationContext context) {
        Validator validator;
        Object validator2;
        ResourceDefinition resourceDefinition;
        ValidationResult lastResult = Validator.INVALID.validate(this.name, input, context);
        if (this.allowableValues != null && !this.allowableValues.isEmpty()) {
            ConstrainedSetValidator csValidator = new ConstrainedSetValidator(this.allowableValues);
            ValidationResult csResult = csValidator.validate(this.name, input, context);
            if (csResult.isValid()) {
                lastResult = csResult;
            } else {
                return csResult;
            }
        }
        if ((resourceDefinition = this.getResourceDefinition()) != null) {
            validator2 = new ResourceDefinitionValidator(resourceDefinition, this.expressionLanguageScope);
            ValidationResult result = validator2.validate(this.name, input, context);
            if (!result.isValid()) {
                return result;
            }
            lastResult = result;
        }
        validator2 = this.validators.iterator();
        while (validator2.hasNext() && (lastResult = (validator = (Validator)validator2.next()).validate(this.name, input, context)).isValid()) {
        }
        if (this.getControllerServiceDefinition() != null) {
            ControllerService service = context.getControllerServiceLookup().getControllerService(input);
            if (service == null) {
                return new ValidationResult.Builder().input(input).subject(this.getDisplayName()).valid(false).explanation("Property references a Controller Service that does not exist").build();
            }
            return new ValidationResult.Builder().valid(true).build();
        }
        return lastResult;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isExpressionLanguageSupported() {
        return this.expressionLanguageSupported || !this.expressionLanguageScope.equals((Object)ExpressionLanguageScope.NONE);
    }

    public ExpressionLanguageScope getExpressionLanguageScope() {
        return this.expressionLanguageScope;
    }

    public boolean isDynamicClasspathModifier() {
        return this.dynamicallyModifiesClasspath;
    }

    public Class<? extends ControllerService> getControllerServiceDefinition() {
        return this.controllerServiceDefinition;
    }

    public List<Validator> getValidators() {
        return this.validators;
    }

    public List<AllowableValue> getAllowableValues() {
        return this.allowableValues;
    }

    public Set<PropertyDependency> getDependencies() {
        return this.dependencies;
    }

    public ResourceDefinition getResourceDefinition() {
        return this.resourceDefinition;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof PropertyDescriptor)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        PropertyDescriptor desc = (PropertyDescriptor)other;
        return this.name.equals(desc.name);
    }

    public int hashCode() {
        return 287 + this.name.hashCode() * 47;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.displayName + "]";
    }

    private static class ResourceDefinitionValidator
    implements Validator {
        private final ResourceDefinition resourceDefinition;
        private final ExpressionLanguageScope expressionLanguageScope;

        public ResourceDefinitionValidator(ResourceDefinition resourceDefinition, ExpressionLanguageScope expressionLanguageScope) {
            this.resourceDefinition = resourceDefinition;
            this.expressionLanguageScope = expressionLanguageScope;
        }

        @Override
        public ValidationResult validate(String subject, String configuredInput, ValidationContext context) {
            boolean allowsText;
            ValidationResult.Builder resultBuilder = new ValidationResult.Builder().input(configuredInput).subject(subject);
            if (configuredInput == null) {
                return resultBuilder.valid(false).explanation("No value specified").build();
            }
            String input = configuredInput;
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(configuredInput)) {
                if (this.expressionLanguageScope != null && this.expressionLanguageScope == ExpressionLanguageScope.VARIABLE_REGISTRY) {
                    input = context.newPropertyValue(configuredInput).evaluateAttributeExpressions().getValue();
                    resultBuilder.input(input);
                } else {
                    return resultBuilder.valid(true).explanation("Expression Language is present, so validation of property value cannot be performed").build();
                }
            }
            if (allowsText = this.resourceDefinition.getResourceTypes().contains((Object)ResourceType.TEXT)) {
                return resultBuilder.valid(true).explanation("Property allows for Resource Type of Text, so validation of property value cannot be performed").build();
            }
            String[] splits = input.split(",");
            if (this.resourceDefinition.getCardinality() == ResourceCardinality.SINGLE && splits.length > 1) {
                return resultBuilder.valid(false).explanation("Property only supports a single Resource but " + splits.length + " resources were specified").build();
            }
            Set<ResourceType> resourceTypes = this.resourceDefinition.getResourceTypes();
            ArrayList<String> nonExistentResources = new ArrayList<String>();
            int count = 0;
            for (String split : splits) {
                ResourceReference resourceReference = new StandardResourceReferenceFactory().createResourceReference(split, this.resourceDefinition);
                if (resourceReference == null) continue;
                ++count;
                boolean accessible = resourceReference.isAccessible();
                if (!accessible) {
                    nonExistentResources.add(resourceReference.getLocation());
                    continue;
                }
                if (resourceTypes.contains((Object)resourceReference.getResourceType())) continue;
                return resultBuilder.valid(false).explanation("Specified Resource is a " + resourceReference.getResourceType().name() + " but this property does not allow this type of resource").build();
            }
            if (count == 0) {
                return resultBuilder.valid(false).explanation("No resources were specified").build();
            }
            if (!nonExistentResources.isEmpty()) {
                return resultBuilder.valid(false).explanation("The specified resource(s) do not exist or could not be accessed: " + nonExistentResources).build();
            }
            return resultBuilder.valid(true).build();
        }
    }

    private static final class ConstrainedSetValidator
    implements Validator {
        private static final String POSITIVE_EXPLANATION = "Given value found in allowed set";
        private static final String NEGATIVE_EXPLANATION = "Given value not found in allowed set '%1$s'";
        private static final String VALUE_DEMARCATOR = ", ";
        private final String validStrings;
        private final Collection<String> validValues;

        private ConstrainedSetValidator(Collection<AllowableValue> validValues) {
            String validVals = "";
            if (!validValues.isEmpty()) {
                StringBuilder valuesBuilder = new StringBuilder();
                for (AllowableValue value : validValues) {
                    valuesBuilder.append(value).append(VALUE_DEMARCATOR);
                }
                validVals = valuesBuilder.substring(0, valuesBuilder.length() - VALUE_DEMARCATOR.length());
            }
            this.validStrings = validVals;
            this.validValues = new ArrayList<String>(validValues.size());
            for (AllowableValue value : validValues) {
                this.validValues.add(value.getValue());
            }
        }

        @Override
        public ValidationResult validate(String subject, String input, ValidationContext context) {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            builder.input(input);
            builder.subject(subject);
            if (this.validValues.contains(input)) {
                builder.valid(true);
                builder.explanation(POSITIVE_EXPLANATION);
            } else {
                builder.valid(false);
                builder.explanation(String.format(NEGATIVE_EXPLANATION, this.validStrings));
            }
            return builder.build();
        }
    }

    public static final class Builder {
        private String displayName = null;
        private String name = null;
        private String description = "";
        private String defaultValue = null;
        private List<AllowableValue> allowableValues = null;
        private Set<PropertyDependency> dependencies = null;
        private boolean required = false;
        private boolean sensitive = false;
        @Deprecated
        private boolean expressionLanguageSupported = false;
        private ExpressionLanguageScope expressionLanguageScope = ExpressionLanguageScope.NONE;
        private boolean dynamic = false;
        private boolean dynamicallyModifiesClasspath = false;
        private Class<? extends ControllerService> controllerServiceDefinition;
        private ResourceDefinition resourceDefinition;
        private List<Validator> validators = new ArrayList<Validator>();

        public Builder fromPropertyDescriptor(PropertyDescriptor specDescriptor) {
            this.name = specDescriptor.name;
            this.displayName = specDescriptor.displayName;
            this.description = specDescriptor.description;
            this.defaultValue = specDescriptor.defaultValue;
            this.allowableValues = specDescriptor.allowableValues == null ? null : new ArrayList<AllowableValue>(specDescriptor.allowableValues);
            this.required = specDescriptor.required;
            this.sensitive = specDescriptor.sensitive;
            this.dynamic = specDescriptor.dynamic;
            this.dynamicallyModifiesClasspath = specDescriptor.dynamicallyModifiesClasspath;
            this.expressionLanguageSupported = specDescriptor.expressionLanguageSupported;
            this.expressionLanguageScope = specDescriptor.expressionLanguageScope;
            this.controllerServiceDefinition = specDescriptor.getControllerServiceDefinition();
            this.validators = new ArrayList<Validator>(specDescriptor.validators);
            this.dependencies = new HashSet<PropertyDependency>(specDescriptor.dependencies);
            this.resourceDefinition = specDescriptor.resourceDefinition;
            return this;
        }

        public Builder displayName(String displayName) {
            if (null != displayName) {
                this.displayName = displayName;
            }
            return this;
        }

        public Builder name(String name) {
            if (null != name) {
                this.name = name;
            }
            return this;
        }

        @Deprecated
        public Builder expressionLanguageSupported(boolean supported) {
            this.expressionLanguageSupported = supported;
            return this;
        }

        public Builder expressionLanguageSupported(ExpressionLanguageScope expressionLanguageScope) {
            this.expressionLanguageScope = expressionLanguageScope;
            return this;
        }

        public Builder description(String description) {
            if (null != description) {
                this.description = description;
            }
            return this;
        }

        public Builder defaultValue(String value) {
            if (null != value) {
                this.defaultValue = value;
            }
            return this;
        }

        public Builder dynamic(boolean dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public Builder dynamicallyModifiesClasspath(boolean dynamicallyModifiesClasspath) {
            this.dynamicallyModifiesClasspath = dynamicallyModifiesClasspath;
            return this;
        }

        public Builder allowableValues(Set<String> values) {
            if (null != values) {
                this.allowableValues = new ArrayList<AllowableValue>();
                for (String value : values) {
                    this.allowableValues.add(new AllowableValue(value, value));
                }
            }
            return this;
        }

        public <E extends Enum<E>> Builder allowableValues(E[] values) {
            if (null != values) {
                this.allowableValues = new ArrayList<AllowableValue>();
                for (E value : values) {
                    this.allowableValues.add(new AllowableValue(((Enum)value).name(), ((Enum)value).name()));
                }
            }
            return this;
        }

        public <E extends Enum<E>> Builder allowableValues(Class<E> enumClass) {
            this.allowableValues = new ArrayList<AllowableValue>();
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                this.allowableValues.add(new AllowableValue(((DescribedValue)((Object)enumValue)).getValue(), ((DescribedValue)((Object)enumValue)).getDisplayName(), ((DescribedValue)((Object)enumValue)).getDescription()));
            }
            return this;
        }

        public Builder allowableValues(String ... values) {
            if (null != values) {
                this.allowableValues = new ArrayList<AllowableValue>();
                for (String value : values) {
                    this.allowableValues.add(new AllowableValue(value, value));
                }
            }
            return this;
        }

        public Builder allowableValues(AllowableValue ... values) {
            if (null != values) {
                this.allowableValues = Arrays.asList(values);
            }
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder sensitive(boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        public Builder addValidator(Validator validator) {
            if (validator != null) {
                this.validators.add(validator);
            }
            return this;
        }

        public Builder identifiesControllerService(Class<? extends ControllerService> controllerServiceDefinition) {
            if (controllerServiceDefinition != null) {
                this.controllerServiceDefinition = controllerServiceDefinition;
            }
            return this;
        }

        private boolean isValueAllowed(String value) {
            if (this.allowableValues == null || value == null) {
                return true;
            }
            for (AllowableValue allowableValue : this.allowableValues) {
                if (!allowableValue.getValue().equals(value)) continue;
                return true;
            }
            return false;
        }

        public Builder identifiesExternalResource(ResourceCardinality cardinality, ResourceType resourceType, ResourceType ... additionalResourceTypes) {
            Objects.requireNonNull(cardinality);
            Objects.requireNonNull(resourceType);
            HashSet<ResourceType> resourceTypes = new HashSet<ResourceType>();
            resourceTypes.add(resourceType);
            resourceTypes.addAll(Arrays.asList(additionalResourceTypes));
            this.resourceDefinition = new StandardResourceDefinition(cardinality, resourceTypes);
            return this;
        }

        public Builder dependsOn(PropertyDescriptor property, AllowableValue ... dependentValues) {
            if (this.dependencies == null) {
                this.dependencies = new HashSet<PropertyDependency>();
            }
            if (dependentValues.length == 0) {
                this.dependencies.add(new PropertyDependency(property.getName(), property.getDisplayName()));
            } else {
                HashSet<String> dependentValueSet = new HashSet<String>();
                for (AllowableValue value : dependentValues) {
                    dependentValueSet.add(value.getValue());
                }
                this.dependencies.add(new PropertyDependency(property.getName(), property.getDisplayName(), dependentValueSet));
            }
            return this;
        }

        public Builder dependsOn(PropertyDescriptor property, String firstDependentValue, String ... additionalDependentValues) {
            AllowableValue[] dependentValues = new AllowableValue[additionalDependentValues.length + 1];
            dependentValues[0] = new AllowableValue(firstDependentValue);
            int i = 1;
            for (String additionalDependentValue : additionalDependentValues) {
                dependentValues[i++] = new AllowableValue(additionalDependentValue);
            }
            return this.dependsOn(property, dependentValues);
        }

        public Builder dependsOn(PropertyDescriptor property, DescribedValue firstDependentValue, DescribedValue ... additionalDependentValues) {
            AllowableValue[] dependentValues = new AllowableValue[additionalDependentValues.length + 1];
            dependentValues[0] = this.toAllowableValue(firstDependentValue);
            int i = 1;
            for (DescribedValue additionalDependentValue : additionalDependentValues) {
                dependentValues[i++] = this.toAllowableValue(additionalDependentValue);
            }
            return this.dependsOn(property, dependentValues);
        }

        private AllowableValue toAllowableValue(DescribedValue describedValue) {
            return new AllowableValue(describedValue.getValue(), describedValue.getDisplayName(), describedValue.getDescription());
        }

        public PropertyDescriptor build() {
            if (this.name == null) {
                throw new IllegalStateException("Must specify a name");
            }
            if (!this.isValueAllowed(this.defaultValue)) {
                throw new IllegalStateException("Default value [" + this.defaultValue + "] is not in the set of allowable values");
            }
            return new PropertyDescriptor(this);
        }
    }
}

