/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.ambari;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.util.metrics.MetricsService;
import org.apache.nifi.reporting.util.metrics.api.MetricsBuilder;
import org.apache.nifi.scheduling.SchedulingStrategy;

@Tags(value={"reporting", "ambari", "metrics"})
@CapabilityDescription(value="Publishes metrics from NiFi to Ambari Metrics Service (AMS). Due to how the Ambari Metrics Service works, this reporting task should be scheduled to run every 60 seconds. Each iteration it will send the metrics from the previous iteration, and calculate the current metrics to be sent on next iteration. Scheduling this reporting task at a frequency other than 60 seconds may produce unexpected results.")
@DeprecationNotice(reason="This reporting task is deprecated and will be removed in NiFi 2.x.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class AmbariReportingTask
extends AbstractReportingTask {
    static final PropertyDescriptor METRICS_COLLECTOR_URL = new PropertyDescriptor.Builder().name("Metrics Collector URL").description("The URL of the Ambari Metrics Collector Service").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("http://localhost:6188/ws/v1/timeline/metrics").addValidator(StandardValidators.URL_VALIDATOR).build();
    static final PropertyDescriptor APPLICATION_ID = new PropertyDescriptor.Builder().name("Application ID").description("The Application ID to be included in the metrics sent to Ambari").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("nifi").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Hostname").description("The Hostname of this NiFi instance to be included in the metrics sent to Ambari").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("${hostname(true)}").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor PROCESS_GROUP_ID = new PropertyDescriptor.Builder().name("Process Group ID").description("If specified, the reporting task will send metrics about this process group only. If not, the root process group is used and global metrics are sent.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private volatile Client client;
    private volatile JsonBuilderFactory factory;
    private volatile JvmMetrics virtualMachineMetrics;
    private volatile JsonObject previousMetrics = null;
    private final MetricsService metricsService = new MetricsService();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(METRICS_COLLECTOR_URL);
        properties.add(APPLICATION_ID);
        properties.add(HOSTNAME);
        properties.add(PROCESS_GROUP_ID);
        return properties;
    }

    @OnScheduled
    public void setup(ConfigurationContext context) throws IOException {
        Map config = Collections.emptyMap();
        this.factory = Json.createBuilderFactory(config);
        this.client = this.createClient();
        this.virtualMachineMetrics = JmxJvmMetrics.getInstance();
        this.previousMetrics = null;
    }

    protected Client createClient() {
        return ClientBuilder.newClient();
    }

    public void onTrigger(ReportingContext context) {
        ProcessGroupStatus status;
        String metricsCollectorUrl = context.getProperty(METRICS_COLLECTOR_URL).evaluateAttributeExpressions().getValue();
        String applicationId = context.getProperty(APPLICATION_ID).evaluateAttributeExpressions().getValue();
        String hostname = context.getProperty(HOSTNAME).evaluateAttributeExpressions().getValue();
        boolean pgIdIsSet = context.getProperty(PROCESS_GROUP_ID).isSet();
        String processGroupId = pgIdIsSet ? context.getProperty(PROCESS_GROUP_ID).evaluateAttributeExpressions().getValue() : null;
        long start = System.currentTimeMillis();
        if (this.previousMetrics != null) {
            WebTarget metricsTarget = this.client.target(metricsCollectorUrl);
            Invocation.Builder invocation = metricsTarget.request();
            Entity entity = Entity.json((Object)this.previousMetrics.toString());
            this.getLogger().debug("Sending metrics {} to Ambari", new Object[]{entity.getEntity()});
            Response response = invocation.post(entity);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                long completedMillis = TimeUnit.NANOSECONDS.toMillis(System.currentTimeMillis() - start);
                this.getLogger().info("Successfully sent metrics to Ambari in {} ms", new Object[]{completedMillis});
            } else {
                String responseEntity = response.hasEntity() ? (String)response.readEntity(String.class) : "unknown error";
                this.getLogger().error("Error sending metrics to Ambari due to {} - {}", new Object[]{response.getStatus(), responseEntity});
            }
        }
        ProcessGroupStatus processGroupStatus = status = processGroupId == null ? context.getEventAccess().getControllerStatus() : context.getEventAccess().getGroupStatus(processGroupId);
        if (status != null) {
            JsonObject metricsObject;
            Map statusMetrics = this.metricsService.getMetrics(status, pgIdIsSet);
            Map jvmMetrics = this.metricsService.getMetrics(this.virtualMachineMetrics);
            MetricsBuilder metricsBuilder = new MetricsBuilder(this.factory);
            this.previousMetrics = metricsObject = metricsBuilder.applicationId(applicationId).instanceId(status.getId()).hostname(hostname).timestamp(start).addAllMetrics(statusMetrics).addAllMetrics(jvmMetrics).build();
        } else {
            this.getLogger().error("No process group status with ID = {}", new Object[]{processGroupId});
            this.previousMetrics = null;
        }
    }
}

