/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.admin.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.ExtensionDetails;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.action.component.details.FlowChangeRemoteProcessGroupDetails;
import org.apache.nifi.action.component.details.RemoteProcessGroupDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.ConfigureDetails;
import org.apache.nifi.action.details.ConnectDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.action.details.FlowChangeConnectDetails;
import org.apache.nifi.action.details.FlowChangeMoveDetails;
import org.apache.nifi.action.details.FlowChangePurgeDetails;
import org.apache.nifi.action.details.MoveDetails;
import org.apache.nifi.action.details.PurgeDetails;
import org.apache.nifi.admin.RepositoryUtils;
import org.apache.nifi.admin.dao.ActionDAO;
import org.apache.nifi.admin.dao.DataAccessException;
import org.apache.nifi.history.History;
import org.apache.nifi.history.HistoryQuery;
import org.apache.nifi.history.PreviousValue;

public class StandardActionDAO
implements ActionDAO {
    private static final String INSERT_ACTION = "INSERT INTO ACTION (IDENTITY, SOURCE_ID, SOURCE_NAME, SOURCE_TYPE, OPERATION, ACTION_TIMESTAMP) VALUES (?, ?, ?, ?, ?, ? )";
    private static final String INSERT_EXTENSION_DETAILS = "INSERT INTO PROCESSOR_DETAILS (ACTION_ID, TYPE) VALUES (?, ?)";
    private static final String INSERT_REMOTE_PROCESS_GROUP_DETAILS = "INSERT INTO REMOTE_PROCESS_GROUP_DETAILS (ACTION_ID, URI) VALUES (?, ?)";
    private static final String INSERT_CONFIGURE_DETAILS = "INSERT INTO CONFIGURE_DETAILS (ACTION_ID, NAME, \"VALUE\", PREVIOUS_VALUE) VALUES (?, ?, ?, ?)";
    private static final String INSERT_CONNECT_DETAILS = "INSERT INTO CONNECT_DETAILS (ACTION_ID, SOURCE_ID, SOURCE_NAME, SOURCE_TYPE, RELATIONSHIP, DESTINATION_ID, DESTINATION_NAME, DESTINATION_TYPE) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_MOVE_DETAILS = "INSERT INTO MOVE_DETAILS (ACTION_ID, GROUP_ID, GROUP_NAME, PREVIOUS_GROUP_ID, PREVIOUS_GROUP_NAME) VALUES (?, ?, ?, ?, ?)";
    private static final String INSERT_PURGE_DETAILS = "INSERT INTO PURGE_DETAILS (ACTION_ID, END_DATE) VALUES (?, ?)";
    private static final String SELECT_ACTIONS = "SELECT * FROM ACTION";
    private static final String SELECT_ACTION_COUNT = "SELECT COUNT(*) AS ACTION_COUNT FROM ACTION";
    private static final String SELECT_ACTION_BY_ID = "SELECT * FROM ACTION WHERE ID = ?";
    private static final String DELETE_ACTIONS = "DELETE FROM ACTION WHERE ACTION_TIMESTAMP < ?";
    private static final String DELETE_SPECIFIC_ACTIONS = "DELETE FROM %s WHERE %s IN (SELECT ID FROM ACTION WHERE ACTION_TIMESTAMP < ?)";
    private static final String SELECT_EXTENSION_DETAILS_FOR_ACTION = "SELECT * FROM PROCESSOR_DETAILS WHERE ACTION_ID = ?";
    private static final String SELECT_REMOTE_PROCESS_GROUP_DETAILS_FOR_ACTION = "SELECT * FROM REMOTE_PROCESS_GROUP_DETAILS WHERE ACTION_ID = ?";
    private static final String SELECT_MOVE_DETAILS_FOR_ACTION = "SELECT * FROM MOVE_DETAILS WHERE ACTION_ID = ?";
    private static final String SELECT_CONFIGURE_DETAILS_FOR_ACTION = "SELECT * FROM CONFIGURE_DETAILS WHERE ACTION_ID = ?";
    private static final String SELECT_CONNECT_DETAILS_FOR_ACTION = "SELECT * FROM CONNECT_DETAILS WHERE ACTION_ID = ?";
    private static final String SELECT_PURGE_DETAILS_FOR_ACTION = "SELECT * FROM PURGE_DETAILS WHERE ACTION_ID = ?";
    private static final String SELECT_PREVIOUSLY_CONFIGURED_FIELDS = "SELECT DISTINCT CD.NAME FROM CONFIGURE_DETAILS CD INNER JOIN ACTION A ON CD.ACTION_ID = A.ID WHERE A.SOURCE_ID = ?";
    private static final String SELECT_PREVIOUS_VALUES = "SELECT CD.\"VALUE\", A.ACTION_TIMESTAMP, A.IDENTITY FROM CONFIGURE_DETAILS CD INNER JOIN ACTION A ON CD.ACTION_ID = A.ID WHERE A.SOURCE_ID = ? AND CD.NAME = ? ORDER BY A.ACTION_TIMESTAMP DESC LIMIT 4";
    private static final String DELETE_PREVIOUS_VALUES = "DELETE FROM CONFIGURE_DETAILS WHERE NAME = ? AND ACTION_ID IN (SELECT ID FROM ACTION WHERE SOURCE_ID = ?)";
    private static final String ACTION_TIMESTAMP = "ACTION_TIMESTAMP";
    private static final String SOURCE_NAME = "SOURCE_NAME";
    private static final String SOURCE_TYPE = "SOURCE_TYPE";
    private static final String OPERATION = "OPERATION";
    private static final String IDENTITY = "IDENTITY";
    private static final String ACTION_ID = "ACTION_ID";
    private static final String SOURCE_ID = "SOURCE_ID";
    private final Connection connection;
    private final Map<String, String> columnMap;

    public StandardActionDAO(Connection connection) {
        this.connection = connection;
        this.columnMap = new HashMap<String, String>();
        this.columnMap.put("timestamp", ACTION_TIMESTAMP);
        this.columnMap.put("sourceName", SOURCE_NAME);
        this.columnMap.put("sourceType", SOURCE_TYPE);
        this.columnMap.put("operation", OPERATION);
        this.columnMap.put("userIdentity", IDENTITY);
    }

    @Override
    public Action createAction(Action action) throws DataAccessException {
        FlowChangeAction flowChangeAction;
        if (action.getUserIdentity() == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        if (action.getTimestamp() == null) {
            throw new IllegalArgumentException("Action timestamp cannot be null.");
        }
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(INSERT_ACTION, 1);
            statement.setString(1, StringUtils.left((String)action.getUserIdentity(), (int)4096));
            statement.setString(2, action.getSourceId());
            statement.setString(3, StringUtils.left((String)action.getSourceName(), (int)1000));
            statement.setString(4, action.getSourceType().name());
            statement.setString(5, action.getOperation().name());
            statement.setTimestamp(6, new Timestamp(action.getTimestamp().getTime()));
            int updateCount = statement.executeUpdate();
            FlowChangeAction createdAction = new FlowChangeAction();
            createdAction.setUserIdentity(action.getUserIdentity());
            createdAction.setSourceId(action.getSourceId());
            createdAction.setSourceName(action.getSourceName());
            createdAction.setSourceType(action.getSourceType());
            createdAction.setOperation(action.getOperation());
            createdAction.setTimestamp(action.getTimestamp());
            createdAction.setActionDetails(action.getActionDetails());
            createdAction.setComponentDetails(action.getComponentDetails());
            rs = statement.getGeneratedKeys();
            if (updateCount != 1 || !rs.next()) {
                throw new DataAccessException("Unable to insert action.");
            }
            createdAction.setId(Integer.valueOf(rs.getInt(1)));
            statement.close();
            ComponentDetails componentDetails = createdAction.getComponentDetails();
            if (componentDetails instanceof FlowChangeExtensionDetails) {
                this.createExtensionDetails(createdAction.getId(), (ExtensionDetails)componentDetails);
            } else if (componentDetails instanceof FlowChangeRemoteProcessGroupDetails) {
                this.createRemoteProcessGroupDetails(createdAction.getId(), (RemoteProcessGroupDetails)componentDetails);
            }
            ActionDetails details = createdAction.getActionDetails();
            if (details instanceof FlowChangeConnectDetails) {
                this.createConnectDetails(createdAction.getId(), (ConnectDetails)details);
            } else if (details instanceof FlowChangeMoveDetails) {
                this.createMoveDetails(createdAction.getId(), (MoveDetails)details);
            } else if (details instanceof FlowChangeConfigureDetails) {
                this.createConfigureDetails(createdAction.getId(), (ConfigureDetails)details);
            } else if (details instanceof FlowChangePurgeDetails) {
                this.createPurgeDetails(createdAction.getId(), (PurgeDetails)details);
            }
            flowChangeAction = createdAction;
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return flowChangeAction;
    }

    private void createExtensionDetails(int actionId, ExtensionDetails extensionDetails) throws DataAccessException {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(INSERT_EXTENSION_DETAILS);
            statement.setInt(1, actionId);
            statement.setString(2, StringUtils.left((String)extensionDetails.getType(), (int)1000));
            int updateCount = statement.executeUpdate();
            if (updateCount != 1) {
                throw new DataAccessException("Unable to insert extension details.");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(statement);
    }

    private void createRemoteProcessGroupDetails(int actionId, RemoteProcessGroupDetails remoteProcessGroupDetails) throws DataAccessException {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(INSERT_REMOTE_PROCESS_GROUP_DETAILS);
            statement.setInt(1, actionId);
            statement.setString(2, StringUtils.left((String)remoteProcessGroupDetails.getUri(), (int)2500));
            int updateCount = statement.executeUpdate();
            if (updateCount != 1) {
                throw new DataAccessException("Unable to insert remote prcoess group details.");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(statement);
    }

    private void createConnectDetails(int actionId, ConnectDetails connectionDetails) throws DataAccessException {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(INSERT_CONNECT_DETAILS);
            statement.setInt(1, actionId);
            statement.setString(2, connectionDetails.getSourceId());
            statement.setString(3, StringUtils.left((String)connectionDetails.getSourceName(), (int)1000));
            statement.setString(4, StringUtils.left((String)connectionDetails.getSourceType().toString(), (int)1000));
            statement.setString(5, StringUtils.left((String)connectionDetails.getRelationship(), (int)1000));
            statement.setString(6, connectionDetails.getDestinationId());
            statement.setString(7, StringUtils.left((String)connectionDetails.getDestinationName(), (int)1000));
            statement.setString(8, StringUtils.left((String)connectionDetails.getDestinationType().toString(), (int)1000));
            int updateCount = statement.executeUpdate();
            if (updateCount != 1) {
                throw new DataAccessException("Unable to insert connection details.");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(statement);
    }

    private void createMoveDetails(int actionId, MoveDetails moveDetails) throws DataAccessException {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(INSERT_MOVE_DETAILS);
            statement.setInt(1, actionId);
            statement.setString(2, moveDetails.getGroupId());
            statement.setString(3, StringUtils.left((String)moveDetails.getGroup(), (int)1000));
            statement.setString(4, moveDetails.getPreviousGroupId());
            statement.setString(5, StringUtils.left((String)moveDetails.getPreviousGroup(), (int)1000));
            int updateCount = statement.executeUpdate();
            if (updateCount != 1) {
                throw new DataAccessException("Unable to insert move details.");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(statement);
    }

    private void createConfigureDetails(int actionId, ConfigureDetails configurationDetails) throws DataAccessException {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(INSERT_CONFIGURE_DETAILS);
            statement.setInt(1, actionId);
            statement.setString(2, StringUtils.left((String)configurationDetails.getName(), (int)1000));
            statement.setString(3, StringUtils.left((String)configurationDetails.getValue(), (int)5000));
            statement.setString(4, StringUtils.left((String)configurationDetails.getPreviousValue(), (int)5000));
            int updateCount = statement.executeUpdate();
            if (updateCount != 1) {
                throw new DataAccessException("Unable to insert configure details.");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(statement);
    }

    private void createPurgeDetails(int actionId, PurgeDetails purgeDetails) throws DataAccessException {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(INSERT_PURGE_DETAILS);
            statement.setInt(1, actionId);
            statement.setTimestamp(2, new Timestamp(purgeDetails.getEndDate().getTime()));
            int updateCount = statement.executeUpdate();
            if (updateCount != 1) {
                throw new DataAccessException("Unable to insert connection details.");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(statement);
    }

    @Override
    public History findActions(HistoryQuery historyQuery) throws DataAccessException {
        String sortColumn = ACTION_TIMESTAMP;
        if (StringUtils.isNotBlank((CharSequence)historyQuery.getSortColumn())) {
            String rawColumnName = historyQuery.getSortColumn();
            if (!this.columnMap.containsKey(rawColumnName)) {
                throw new IllegalArgumentException(String.format("Unrecognized column name '%s'.", rawColumnName));
            }
            sortColumn = this.columnMap.get(rawColumnName);
        }
        String sortOrder = (String)StringUtils.defaultIfBlank((CharSequence)historyQuery.getSortOrder(), (CharSequence)"desc");
        History actionResult = new History();
        ArrayList<Action> actions = new ArrayList<Action>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            ArrayList<String> where = new ArrayList<String>();
            if (historyQuery.getStartDate() != null) {
                where.add("ACTION_TIMESTAMP >= ?");
            }
            if (historyQuery.getEndDate() != null) {
                where.add("ACTION_TIMESTAMP <= ?");
            }
            if (historyQuery.getUserIdentity() != null) {
                where.add("UPPER(IDENTITY) LIKE ?");
            }
            if (historyQuery.getSourceId() != null) {
                where.add("SOURCE_ID = ?");
            }
            Object sql = SELECT_ACTION_COUNT;
            if (!where.isEmpty()) {
                sql = (String)sql + " WHERE " + StringUtils.join(where, (String)" AND ");
            }
            statement = this.connection.prepareStatement((String)sql);
            int paramIndex = 1;
            if (historyQuery.getStartDate() != null) {
                statement.setTimestamp(paramIndex++, new Timestamp(historyQuery.getStartDate().getTime()));
            }
            if (historyQuery.getEndDate() != null) {
                statement.setTimestamp(paramIndex++, new Timestamp(historyQuery.getEndDate().getTime()));
            }
            if (historyQuery.getUserIdentity() != null) {
                statement.setString(paramIndex++, "%" + historyQuery.getUserIdentity().toUpperCase() + "%");
            }
            if (historyQuery.getSourceId() != null) {
                statement.setString(paramIndex, historyQuery.getSourceId());
            }
            if (!(rs = statement.executeQuery()).next()) {
                throw new DataAccessException("Unable to determine total action count.");
            }
            actionResult.setTotal(rs.getInt("ACTION_COUNT"));
            sql = SELECT_ACTIONS;
            if (!where.isEmpty()) {
                sql = (String)sql + " WHERE " + StringUtils.join(where, (String)" AND ");
            }
            sql = (String)sql + " ORDER BY " + sortColumn + " " + sortOrder;
            sql = (String)sql + " LIMIT ? OFFSET ?";
            statement.close();
            statement = this.connection.prepareStatement((String)sql);
            paramIndex = 1;
            if (historyQuery.getStartDate() != null) {
                statement.setTimestamp(paramIndex++, new Timestamp(historyQuery.getStartDate().getTime()));
            }
            if (historyQuery.getEndDate() != null) {
                statement.setTimestamp(paramIndex++, new Timestamp(historyQuery.getEndDate().getTime()));
            }
            if (historyQuery.getUserIdentity() != null) {
                statement.setString(paramIndex++, "%" + historyQuery.getUserIdentity().toUpperCase() + "%");
            }
            if (historyQuery.getSourceId() != null) {
                statement.setString(paramIndex++, historyQuery.getSourceId());
            }
            statement.setInt(paramIndex++, historyQuery.getCount());
            statement.setInt(paramIndex, historyQuery.getOffset());
            rs = statement.executeQuery();
            while (rs.next()) {
                Integer actionId = rs.getInt("ID");
                Operation operation = Operation.valueOf((String)rs.getString(OPERATION));
                Component component = Component.valueOf((String)rs.getString(SOURCE_TYPE));
                FlowChangeAction action = new FlowChangeAction();
                action.setId(actionId);
                action.setUserIdentity(rs.getString(IDENTITY));
                action.setOperation(Operation.valueOf((String)rs.getString(OPERATION)));
                action.setTimestamp(new Date(rs.getTimestamp(ACTION_TIMESTAMP).getTime()));
                action.setSourceId(rs.getString(SOURCE_ID));
                action.setSourceName(rs.getString(SOURCE_NAME));
                action.setSourceType(Component.valueOf((String)rs.getString(SOURCE_TYPE)));
                ExtensionDetails componentDetails = null;
                if (Component.Processor.equals((Object)component) || Component.ControllerService.equals((Object)component) || Component.ReportingTask.equals((Object)component) || Component.ParameterProvider.equals((Object)component)) {
                    componentDetails = this.getExtensionDetails(actionId);
                } else if (Component.RemoteProcessGroup.equals((Object)component)) {
                    componentDetails = this.getRemoteProcessGroupDetails(actionId);
                }
                if (componentDetails != null) {
                    action.setComponentDetails((ComponentDetails)componentDetails);
                }
                MoveDetails actionDetails = null;
                if (Operation.Move.equals((Object)operation)) {
                    actionDetails = this.getMoveDetails(actionId);
                } else if (Operation.Configure.equals((Object)operation)) {
                    actionDetails = this.getConfigureDetails(actionId);
                } else if (Operation.Connect.equals((Object)operation) || Operation.Disconnect.equals((Object)operation)) {
                    actionDetails = this.getConnectDetails(actionId);
                } else if (Operation.Purge.equals((Object)operation)) {
                    actionDetails = this.getPurgeDetails(actionId);
                }
                if (actionDetails != null) {
                    action.setActionDetails((ActionDetails)actionDetails);
                }
                actions.add((Action)action);
            }
            actionResult.setActions(actions);
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return actionResult;
    }

    @Override
    public Action getAction(Integer actionId) throws DataAccessException {
        ResultSet rs;
        PreparedStatement statement;
        FlowChangeAction action;
        block16: {
            action = null;
            statement = null;
            rs = null;
            try {
                statement = this.connection.prepareStatement(SELECT_ACTION_BY_ID);
                statement.setInt(1, actionId);
                rs = statement.executeQuery();
                if (!rs.next()) break block16;
                Operation operation = Operation.valueOf((String)rs.getString(OPERATION));
                Component component = Component.valueOf((String)rs.getString(SOURCE_TYPE));
                action = new FlowChangeAction();
                action.setId(Integer.valueOf(rs.getInt("ID")));
                action.setUserIdentity(rs.getString(IDENTITY));
                action.setOperation(operation);
                action.setTimestamp(new Date(rs.getTimestamp(ACTION_TIMESTAMP).getTime()));
                action.setSourceId(rs.getString(SOURCE_ID));
                action.setSourceName(rs.getString(SOURCE_NAME));
                action.setSourceType(component);
                ExtensionDetails componentDetails = null;
                if (Component.Processor.equals((Object)component) || Component.ControllerService.equals((Object)component) || Component.ReportingTask.equals((Object)component) || Component.ParameterProvider.equals((Object)component) || Component.FlowRegistryClient.equals((Object)component)) {
                    componentDetails = this.getExtensionDetails(actionId);
                } else if (Component.RemoteProcessGroup.equals((Object)component)) {
                    componentDetails = this.getRemoteProcessGroupDetails(actionId);
                }
                if (componentDetails != null) {
                    action.setComponentDetails((ComponentDetails)componentDetails);
                }
                MoveDetails actionDetails = null;
                if (Operation.Move.equals((Object)operation)) {
                    actionDetails = this.getMoveDetails(actionId);
                } else if (Operation.Configure.equals((Object)operation)) {
                    actionDetails = this.getConfigureDetails(actionId);
                } else if (Operation.Connect.equals((Object)operation) || Operation.Disconnect.equals((Object)operation)) {
                    actionDetails = this.getConnectDetails(actionId);
                } else if (Operation.Purge.equals((Object)operation)) {
                    actionDetails = this.getPurgeDetails(actionId);
                }
                if (actionDetails != null) {
                    action.setActionDetails((ActionDetails)actionDetails);
                }
            }
            catch (SQLException sqle) {
                try {
                    throw new DataAccessException(sqle);
                }
                catch (Throwable throwable) {
                    RepositoryUtils.closeQuietly(rs);
                    RepositoryUtils.closeQuietly(statement);
                    throw throwable;
                }
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return action;
    }

    private ExtensionDetails getExtensionDetails(Integer actionId) throws DataAccessException {
        FlowChangeExtensionDetails extensionDetails = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_EXTENSION_DETAILS_FOR_ACTION);
            statement.setInt(1, actionId);
            rs = statement.executeQuery();
            if (rs.next()) {
                extensionDetails = new FlowChangeExtensionDetails();
                extensionDetails.setType(rs.getString("TYPE"));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return extensionDetails;
    }

    private RemoteProcessGroupDetails getRemoteProcessGroupDetails(Integer actionId) throws DataAccessException {
        FlowChangeRemoteProcessGroupDetails remoteProcessGroupDetails = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_REMOTE_PROCESS_GROUP_DETAILS_FOR_ACTION);
            statement.setInt(1, actionId);
            rs = statement.executeQuery();
            if (rs.next()) {
                remoteProcessGroupDetails = new FlowChangeRemoteProcessGroupDetails();
                remoteProcessGroupDetails.setUri(rs.getString("URI"));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return remoteProcessGroupDetails;
    }

    private MoveDetails getMoveDetails(Integer actionId) throws DataAccessException {
        FlowChangeMoveDetails moveDetails = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_MOVE_DETAILS_FOR_ACTION);
            statement.setInt(1, actionId);
            rs = statement.executeQuery();
            if (rs.next()) {
                moveDetails = new FlowChangeMoveDetails();
                moveDetails.setGroupId(rs.getString("GROUP_ID"));
                moveDetails.setGroup(rs.getString("GROUP_NAME"));
                moveDetails.setPreviousGroupId(rs.getString("PREVIOUS_GROUP_ID"));
                moveDetails.setPreviousGroup(rs.getString("PREVIOUS_GROUP_NAME"));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return moveDetails;
    }

    private ConnectDetails getConnectDetails(Integer actionId) throws DataAccessException {
        FlowChangeConnectDetails connectionDetails = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_CONNECT_DETAILS_FOR_ACTION);
            statement.setInt(1, actionId);
            rs = statement.executeQuery();
            if (rs.next()) {
                Component sourceComponent = Component.valueOf((String)rs.getString(SOURCE_TYPE));
                Component destinationComponent = Component.valueOf((String)rs.getString("DESTINATION_TYPE"));
                connectionDetails = new FlowChangeConnectDetails();
                connectionDetails.setSourceId(rs.getString(SOURCE_ID));
                connectionDetails.setSourceName(rs.getString(SOURCE_NAME));
                connectionDetails.setSourceType(sourceComponent);
                connectionDetails.setRelationship(rs.getString("RELATIONSHIP"));
                connectionDetails.setDestinationId(rs.getString("DESTINATION_ID"));
                connectionDetails.setDestinationName(rs.getString("DESTINATION_NAME"));
                connectionDetails.setDestinationType(destinationComponent);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return connectionDetails;
    }

    private ConfigureDetails getConfigureDetails(Integer actionId) throws DataAccessException {
        FlowChangeConfigureDetails configurationDetails = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_CONFIGURE_DETAILS_FOR_ACTION);
            statement.setInt(1, actionId);
            rs = statement.executeQuery();
            if (rs.next()) {
                configurationDetails = new FlowChangeConfigureDetails();
                configurationDetails.setName(rs.getString("NAME"));
                configurationDetails.setValue(rs.getString("VALUE"));
                configurationDetails.setPreviousValue(rs.getString("PREVIOUS_VALUE"));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return configurationDetails;
    }

    private PurgeDetails getPurgeDetails(Integer actionId) throws DataAccessException {
        FlowChangePurgeDetails purgeDetails = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_PURGE_DETAILS_FOR_ACTION);
            statement.setInt(1, actionId);
            rs = statement.executeQuery();
            if (rs.next()) {
                purgeDetails = new FlowChangePurgeDetails();
                purgeDetails.setEndDate(new Date(rs.getTimestamp("END_DATE").getTime()));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return purgeDetails;
    }

    @Override
    public Map<String, List<PreviousValue>> getPreviousValues(String componentId) {
        LinkedHashMap<String, List<PreviousValue>> previousValues = new LinkedHashMap<String, List<PreviousValue>>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_PREVIOUSLY_CONFIGURED_FIELDS);
            statement.setString(1, componentId);
            rs = statement.executeQuery();
            while (rs.next()) {
                String property = rs.getString("NAME");
                previousValues.put(property, this.getPreviousValuesForProperty(componentId, property));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return previousValues;
    }

    private List<PreviousValue> getPreviousValuesForProperty(String componentId, String property) {
        ArrayList<PreviousValue> previousValues = new ArrayList<PreviousValue>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_PREVIOUS_VALUES);
            statement.setString(1, componentId);
            statement.setString(2, property);
            rs = statement.executeQuery();
            while (rs.next()) {
                PreviousValue previousValue = new PreviousValue();
                previousValue.setPreviousValue(rs.getString("VALUE"));
                previousValue.setTimestamp(new Date(rs.getTimestamp(ACTION_TIMESTAMP).getTime()));
                previousValue.setUserIdentity(rs.getString(IDENTITY));
                previousValues.add(previousValue);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return previousValues;
    }

    @Override
    public void deleteActions(Date endDate) throws DataAccessException {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(String.format(DELETE_SPECIFIC_ACTIONS, "PROCESSOR_DETAILS", ACTION_ID));
            statement.setTimestamp(1, new Timestamp(endDate.getTime()));
            statement.executeUpdate();
            statement.close();
            statement = this.connection.prepareStatement(String.format(DELETE_SPECIFIC_ACTIONS, "REMOTE_PROCESS_GROUP_DETAILS", ACTION_ID));
            statement.setTimestamp(1, new Timestamp(endDate.getTime()));
            statement.executeUpdate();
            statement.close();
            statement = this.connection.prepareStatement(String.format(DELETE_SPECIFIC_ACTIONS, "MOVE_DETAILS", ACTION_ID));
            statement.setTimestamp(1, new Timestamp(endDate.getTime()));
            statement.executeUpdate();
            statement.close();
            statement = this.connection.prepareStatement(String.format(DELETE_SPECIFIC_ACTIONS, "CONFIGURE_DETAILS", ACTION_ID));
            statement.setTimestamp(1, new Timestamp(endDate.getTime()));
            statement.executeUpdate();
            statement.close();
            statement = this.connection.prepareStatement(String.format(DELETE_SPECIFIC_ACTIONS, "CONNECT_DETAILS", ACTION_ID));
            statement.setTimestamp(1, new Timestamp(endDate.getTime()));
            statement.executeUpdate();
            statement.close();
            statement = this.connection.prepareStatement(String.format(DELETE_SPECIFIC_ACTIONS, "PURGE_DETAILS", ACTION_ID));
            statement.setTimestamp(1, new Timestamp(endDate.getTime()));
            statement.executeUpdate();
            statement.close();
            statement = this.connection.prepareStatement(DELETE_ACTIONS);
            statement.setTimestamp(1, new Timestamp(endDate.getTime()));
            statement.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(statement);
    }

    @Override
    public void deletePreviousValues(String propertyName, String componentId) {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(DELETE_PREVIOUS_VALUES);
            statement.setString(1, propertyName);
            statement.setString(2, componentId);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(statement);
    }
}

