/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.admin;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.admin.RepositoryUtils;
import org.apache.nifi.h2.database.migration.H2DatabaseUpdater;
import org.apache.nifi.util.NiFiProperties;
import org.h2.jdbcx.JdbcConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class IdpDataSourceFactoryBean
implements FactoryBean<JdbcConnectionPool> {
    private static final Logger logger = LoggerFactory.getLogger(IdpDataSourceFactoryBean.class);
    private static final String NF_USERNAME_PASSWORD = "nf";
    private static final int MAX_CONNECTIONS = 5;
    private static final String IDP_DATABASE_FILE_NAME = "nifi-identity-providers";
    private static final String IDP_USER_GROUP_TABLE_NAME = "IDENTITY_PROVIDER_USER_GROUP";
    private static final String CREATE_IDP_USER_GROUP_TABLE = "CREATE TABLE IDENTITY_PROVIDER_USER_GROUP (ID INT NOT NULL PRIMARY KEY AUTO_INCREMENT, IDENTITY VARCHAR2(4096) NOT NULL, IDP_TYPE VARCHAR2(200) NOT NULL, GROUP_NAME VARCHAR2(4096) NOT NULL, CREATED TIMESTAMP NOT NULL, CONSTRAINT UK__IDENTITY_GROUP_NAME UNIQUE (IDENTITY, GROUP_NAME))";
    private JdbcConnectionPool connectionPool;
    private NiFiProperties properties;

    public JdbcConnectionPool getObject() throws Exception {
        if (this.connectionPool == null) {
            String repositoryDirectoryPath = this.properties.getProperty("nifi.database.directory");
            if (repositoryDirectoryPath == null) {
                throw new NullPointerException("Database directory must be specified.");
            }
            File repositoryDirectory = new File(repositoryDirectoryPath);
            File dbFileNoExtension = new File(repositoryDirectory, IDP_DATABASE_FILE_NAME);
            String databaseUrl = this.getDatabaseUrl(dbFileNoExtension);
            String migrationDbUrl = "jdbc:h2:" + dbFileNoExtension + ";LOCK_MODE=3";
            H2DatabaseUpdater.checkAndPerformMigration((String)dbFileNoExtension.getAbsolutePath(), (String)migrationDbUrl, (String)NF_USERNAME_PASSWORD, (String)NF_USERNAME_PASSWORD);
            this.connectionPool = JdbcConnectionPool.create((String)databaseUrl, (String)NF_USERNAME_PASSWORD, (String)NF_USERNAME_PASSWORD);
            this.connectionPool.setMaxConnections(5);
            Connection connection = null;
            ResultSet rs = null;
            Statement statement = null;
            try {
                connection = this.connectionPool.getConnection();
                connection.setAutoCommit(false);
                statement = connection.createStatement();
                rs = connection.getMetaData().getTables(null, null, IDP_USER_GROUP_TABLE_NAME, null);
                if (!rs.next()) {
                    statement.execute(CREATE_IDP_USER_GROUP_TABLE);
                }
                connection.commit();
            }
            catch (SQLException sqle) {
                try {
                    RepositoryUtils.rollback(connection, logger);
                    throw sqle;
                }
                catch (Throwable throwable) {
                    RepositoryUtils.closeQuietly(rs);
                    RepositoryUtils.closeQuietly(statement);
                    RepositoryUtils.closeQuietly(connection);
                    throw throwable;
                }
            }
            RepositoryUtils.closeQuietly(rs);
            RepositoryUtils.closeQuietly(statement);
            RepositoryUtils.closeQuietly(connection);
        }
        return this.connectionPool;
    }

    private String getDatabaseUrl(File databaseFile) {
        String databaseUrl = "jdbc:h2:" + databaseFile + ";AUTOCOMMIT=OFF;DB_CLOSE_ON_EXIT=FALSE;LOCK_MODE=3";
        String databaseUrlAppend = this.properties.getProperty("nifi.h2.url.append");
        if (StringUtils.isNotBlank((CharSequence)databaseUrlAppend)) {
            databaseUrl = databaseUrl + databaseUrlAppend;
        }
        return databaseUrl;
    }

    public Class getObjectType() {
        return JdbcConnectionPool.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void shutdown() {
        block3: {
            if (this.connectionPool != null) {
                try {
                    this.connectionPool.dispose();
                }
                catch (Exception e) {
                    logger.warn("Unable to dispose of connection pool: " + e.getMessage());
                    if (!logger.isDebugEnabled()) break block3;
                    logger.warn("", (Throwable)e);
                }
            }
        }
    }
}

