/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.ClasspathConfiguration;

public class StartupConfiguration {
    private final String providerClassName;
    private final ClasspathConfiguration classpathConfiguration;
    private final ClassLoaderConfiguration classLoaderConfiguration;
    private final boolean isForkRequested;
    private final boolean isInForkedVm;
    private static final String SUREFIRE_TEST_CLASSPATH = "surefire.test.class.path";

    public StartupConfiguration(String providerClassName, ClasspathConfiguration classpathConfiguration, ClassLoaderConfiguration classLoaderConfiguration, String forkMode, boolean inForkedVm) {
        this.providerClassName = providerClassName;
        this.classpathConfiguration = classpathConfiguration;
        this.classLoaderConfiguration = classLoaderConfiguration;
        this.isForkRequested = !"never".equals(forkMode);
        this.isInForkedVm = inForkedVm;
    }

    public static StartupConfiguration inForkedVm(String providerClassName, ClasspathConfiguration classpathConfiguration, ClassLoaderConfiguration classLoaderConfiguration, String forkMode) {
        return new StartupConfiguration(providerClassName, classpathConfiguration, classLoaderConfiguration, forkMode, true);
    }

    public ClasspathConfiguration getClasspathConfiguration() {
        return this.classpathConfiguration;
    }

    public boolean useSystemClassLoader() {
        return this.classLoaderConfiguration.isUseSystemClassLoader() && (this.isInForkedVm || this.isForkRequested);
    }

    public boolean isManifestOnlyJarRequestedAndUsable() {
        return this.classLoaderConfiguration.isManifestOnlyJarRequestedAndUsable();
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public ClassLoaderConfiguration getClassLoaderConfiguration() {
        return this.classLoaderConfiguration;
    }

    public boolean isShadefire() {
        return this.providerClassName.startsWith("org.apache.maven.surefire.shadefire");
    }

    public void writeSurefireTestClasspathProperty() {
        ClasspathConfiguration classpathConfiguration = this.getClasspathConfiguration();
        classpathConfiguration.getTestClasspath().writeToSystemProperty(SUREFIRE_TEST_CLASSPATH);
    }
}

