/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.surefire.util.NestedRuntimeException;

public class ChecksumCalculator {
    private static final String HEX = "0123456789ABCDEF";
    private final List checksumItems = new ArrayList();

    private void appendObject(Object item) {
        this.checksumItems.add(item);
    }

    public void add(boolean value) {
        this.checksumItems.add(value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void add(int value) {
        this.checksumItems.add(new Integer(value));
    }

    public void add(Map map) {
        if (map != null) {
            this.appendObject(map.toString());
        }
    }

    public void add(String string) {
        this.appendObject(string);
    }

    public void add(File workingDirectory) {
        this.appendObject(workingDirectory);
    }

    public void add(ArtifactRepository localRepository) {
        this.appendObject(localRepository);
    }

    public void add(List items) {
        if (items != null) {
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                Object item = items.get(i);
                this.appendObject(item);
            }
        } else {
            this.appendObject(null);
        }
    }

    public void add(File[] fileList) {
        if (fileList != null) {
            int size = fileList.length;
            for (int i = 0; i < size; ++i) {
                this.appendObject(fileList[i]);
            }
        } else {
            this.appendObject(null);
        }
    }

    public void add(Artifact artifact) {
        this.appendObject(artifact != null ? artifact.getId() : null);
    }

    public void add(Boolean aBoolean) {
        this.appendObject(aBoolean);
    }

    private static String asHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int size = bytes.length;
        StringBuilder result = new StringBuilder(2 * size);
        for (int i = 0; i < size; ++i) {
            byte b = bytes[i];
            result.append(HEX.charAt((b & 0xF0) >> 4)).append(HEX.charAt(b & 0xF));
        }
        return result.toString();
    }

    private String getConfig() {
        StringBuilder result = new StringBuilder();
        for (Object item : this.checksumItems) {
            result.append(item != null ? item.toString() : "null");
        }
        return result.toString();
    }

    public String getSha1() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            String configValue = this.getConfig();
            md.update(configValue.getBytes("iso-8859-1"), 0, configValue.length());
            byte[] sha1hash = md.digest();
            return ChecksumCalculator.asHexString(sha1hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }
}

