/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.trogdor.agent.AgentClient;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.coordinator.CoordinatorClient;
import org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.kafka.trogdor.rest.TaskState;
import org.apache.kafka.trogdor.rest.TasksRequest;
import org.apache.kafka.trogdor.rest.TasksResponse;
import org.apache.kafka.trogdor.rest.WorkerState;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectedTasks {
    private static final Logger log = LoggerFactory.getLogger(ExpectedTasks.class);
    private final TreeMap<String, ExpectedTask> expected = new TreeMap();

    public ExpectedTasks addTask(ExpectedTask task) {
        this.expected.put(task.id, task);
        return this;
    }

    public ExpectedTasks waitFor(CoordinatorClient client) throws InterruptedException {
        TestUtils.waitForCondition(() -> {
            TasksResponse tasks = null;
            try {
                tasks = client.tasks(new TasksRequest(null, 0L, 0L, 0L, 0L, Optional.empty()));
            }
            catch (Exception e) {
                log.info("Unable to get coordinator tasks", (Throwable)e);
                throw new RuntimeException(e);
            }
            StringBuilder errors = new StringBuilder();
            for (Map.Entry<String, ExpectedTask> entry : this.expected.entrySet()) {
                String id = entry.getKey();
                ExpectedTask task = entry.getValue();
                String differences = task.compare((TaskState)tasks.tasks().get(id));
                if (differences == null) continue;
                errors.append(differences);
            }
            String errorString = errors.toString();
            if (!errorString.isEmpty()) {
                log.info("EXPECTED TASKS: {}", (Object)JsonUtil.toJsonString(this.expected));
                log.info("ACTUAL TASKS  : {}", (Object)JsonUtil.toJsonString((Object)tasks.tasks()));
                log.info(errorString);
                return false;
            }
            return true;
        }, (String)("Timed out waiting for expected tasks " + JsonUtil.toJsonString(this.expected)));
        return this;
    }

    public ExpectedTasks waitFor(AgentClient client) throws InterruptedException {
        TestUtils.waitForCondition(() -> {
            AgentStatusResponse status = null;
            try {
                status = client.status();
            }
            catch (Exception e) {
                log.info("Unable to get agent status", (Throwable)e);
                throw new RuntimeException(e);
            }
            StringBuilder errors = new StringBuilder();
            HashMap<String, WorkerState> taskIdToWorkerState = new HashMap<String, WorkerState>();
            for (WorkerState workerState : status.workers().values()) {
                taskIdToWorkerState.put(workerState.taskId(), workerState);
            }
            for (Map.Entry entry : this.expected.entrySet()) {
                String id = (String)entry.getKey();
                ExpectedTask worker = (ExpectedTask)entry.getValue();
                String differences = worker.compare((WorkerState)taskIdToWorkerState.get(id));
                if (differences == null) continue;
                errors.append(differences);
            }
            String errorString = errors.toString();
            if (!errorString.isEmpty()) {
                log.info("EXPECTED WORKERS: {}", (Object)JsonUtil.toJsonString(this.expected));
                log.info("ACTUAL WORKERS  : {}", (Object)JsonUtil.toJsonString((Object)status.workers()));
                log.info(errorString);
                return false;
            }
            return true;
        }, (String)("Timed out waiting for expected workers " + JsonUtil.toJsonString(this.expected)));
        return this;
    }

    public static class ExpectedTask {
        private final String id;
        private final TaskSpec taskSpec;
        private final TaskState taskState;
        private final WorkerState workerState;

        @JsonCreator
        private ExpectedTask(@JsonProperty(value="id") String id, @JsonProperty(value="taskSpec") TaskSpec taskSpec, @JsonProperty(value="taskState") TaskState taskState, @JsonProperty(value="workerState") WorkerState workerState) {
            this.id = id;
            this.taskSpec = taskSpec;
            this.taskState = taskState;
            this.workerState = workerState;
        }

        String compare(TaskState actual) {
            if (actual == null) {
                return "Did not find task " + this.id + "\n";
            }
            if (this.taskSpec != null && !actual.spec().equals((Object)this.taskSpec)) {
                return "Invalid spec for task " + this.id + ": expected " + this.taskSpec + ", got " + actual.spec();
            }
            if (this.taskState != null && !actual.equals((Object)this.taskState)) {
                return "Invalid state for task " + this.id + ": expected " + this.taskState + ", got " + actual;
            }
            return null;
        }

        String compare(WorkerState actual) {
            if (this.workerState != null && !this.workerState.equals((Object)actual)) {
                if (actual == null) {
                    return "Did not find worker " + this.id + "\n";
                }
                return "Invalid state for task " + this.id + ": expected " + this.workerState + ", got " + actual;
            }
            return null;
        }

        @JsonProperty
        public String id() {
            return this.id;
        }

        @JsonProperty
        public TaskSpec taskSpec() {
            return this.taskSpec;
        }

        @JsonProperty
        public TaskState taskState() {
            return this.taskState;
        }

        @JsonProperty
        public WorkerState workerState() {
            return this.workerState;
        }
    }

    public static class ExpectedTaskBuilder {
        private final String id;
        private TaskSpec taskSpec = null;
        private TaskState taskState = null;
        private WorkerState workerState = null;

        public ExpectedTaskBuilder(String id) {
            this.id = id;
        }

        public ExpectedTaskBuilder taskSpec(TaskSpec taskSpec) {
            this.taskSpec = taskSpec;
            return this;
        }

        public ExpectedTaskBuilder taskState(TaskState taskState) {
            this.taskState = taskState;
            return this;
        }

        public ExpectedTaskBuilder workerState(WorkerState workerState) {
            this.workerState = workerState;
            return this;
        }

        public ExpectedTask build() {
            return new ExpectedTask(this.id, this.taskSpec, this.taskState, this.workerState);
        }
    }
}

