/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.mapr.tools;

import com.mapr.fs.MapRFileAce;
import com.mapr.security.UnixUserGroupHelper;
import java.util.List;
import org.apache.kafka.mapr.tools.KafkaMaprTools;
import org.apache.kafka.mapr.tools.MaprfsPermissions;
import org.apache.kafka.mapr.tools.SuppressionUtil;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class MaprfsPermissionsTest {
    private static final String MAPRUSER_1 = "mapruser1";
    private static final String MAPRUSER_1_ACE = "u:mapruser1";
    private static final String MAPR = "mapr";
    private static final String MAPR_ACE = "u:mapr";

    @Test
    public void parseEmptyPermissionsFromEmptyConfigurationValue() {
        MaprfsPermissions permissions = MaprfsPermissions.permissions().loadFromConfig("");
        Assert.assertEquals((Object)permissions, (Object)MaprfsPermissions.permissions());
    }

    @Test
    public void parseFewPermissionsFromConfigurationValue() {
        MaprfsPermissions permissions = MaprfsPermissions.permissions().loadFromConfig("readdir=u:mapr; lookupdir=u:mapruser1");
        Assert.assertEquals((Object)permissions, (Object)MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, MAPR_ACE).put(MapRFileAce.AccessType.LOOKUPDIR, MAPRUSER_1_ACE));
    }

    @Test
    public void parsePermissionsFromConfigurationValueWithDuplicates() {
        MaprfsPermissions permissions = MaprfsPermissions.permissions().loadFromConfig("readdir=u:mapr; lookupdir=u:mapruser1; readdir=u:mapruser1");
        Assert.assertEquals((Object)permissions, (Object)MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, MAPRUSER_1_ACE).put(MapRFileAce.AccessType.LOOKUPDIR, MAPRUSER_1_ACE));
    }

    @Test
    public void parsePermissionsFromConfigurationValueWithSubstitution() {
        KafkaMaprTools.tools = (KafkaMaprTools)EasyMock.mock(KafkaMaprTools.class);
        EasyMock.expect((Object)KafkaMaprTools.tools().getCurrentUserName()).andStubReturn((Object)MAPRUSER_1);
        EasyMock.expect((Object)KafkaMaprTools.tools().getClusterAdminUserName()).andStubReturn((Object)MAPR);
        EasyMock.replay((Object[])new Object[]{KafkaMaprTools.tools()});
        MaprfsPermissions permissions = MaprfsPermissions.permissions().loadFromConfig("readdir=<cluster.admin> | <startup.user>");
        Assert.assertEquals((Object)permissions, (Object)MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, "u:mapr | u:mapruser1"));
    }

    @Test
    public void parsePermissionsFromConfigurationValueAndOverrideOldValues() {
        MaprfsPermissions permissions = MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, MAPR_ACE).put(MapRFileAce.AccessType.LOOKUPDIR, MAPR_ACE).put(MapRFileAce.AccessType.ADDCHILD, MAPR_ACE).put(MapRFileAce.AccessType.DELETECHILD, MAPR_ACE).loadFromConfig("readdir=u:mapr; lookupdir=u:mapruser1; readdir=u:mapruser1");
        Assert.assertEquals((Object)permissions, (Object)MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, MAPRUSER_1_ACE).put(MapRFileAce.AccessType.LOOKUPDIR, MAPRUSER_1_ACE).put(MapRFileAce.AccessType.ADDCHILD, MAPR_ACE).put(MapRFileAce.AccessType.DELETECHILD, MAPR_ACE));
    }

    @Test
    public void buildAceList() throws IllegalAccessException {
        UnixUserGroupHelper idMapper = (UnixUserGroupHelper)EasyMock.mock(UnixUserGroupHelper.class);
        SuppressionUtil.setAceUnixUserGroupHelper(idMapper);
        EasyMock.expect((Object)idMapper.getUserId(MAPRUSER_1)).andStubReturn((Object)1001);
        EasyMock.expect((Object)idMapper.getUserId(MAPR)).andStubReturn((Object)1000);
        EasyMock.replay((Object[])new Object[]{idMapper});
        List aceList = MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, MAPRUSER_1_ACE).put(MapRFileAce.AccessType.LOOKUPDIR, MAPRUSER_1_ACE).put(MapRFileAce.AccessType.ADDCHILD, MAPR_ACE).put(MapRFileAce.AccessType.DELETECHILD, MAPR_ACE).buildAceList();
        Assert.assertEquals((long)4L, (long)aceList.size());
        MatcherAssert.assertThat((Object)this.findFromList(aceList, MapRFileAce.AccessType.READDIR), (Matcher)CoreMatchers.equalTo((Object)MAPRUSER_1_ACE));
        MatcherAssert.assertThat((Object)this.findFromList(aceList, MapRFileAce.AccessType.LOOKUPDIR), (Matcher)CoreMatchers.equalTo((Object)MAPRUSER_1_ACE));
        MatcherAssert.assertThat((Object)this.findFromList(aceList, MapRFileAce.AccessType.ADDCHILD), (Matcher)CoreMatchers.equalTo((Object)MAPR_ACE));
        MatcherAssert.assertThat((Object)this.findFromList(aceList, MapRFileAce.AccessType.DELETECHILD), (Matcher)CoreMatchers.equalTo((Object)MAPR_ACE));
    }

    private String findFromList(List<MapRFileAce> aceList, MapRFileAce.AccessType type) {
        return aceList.stream().filter(ace -> ace.getAccessType() == type).map(MapRFileAce::getBooleanExpression).findFirst().orElse(null);
    }
}

