/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.mapr.tools;

import com.mapr.fs.MapRFileSystem;
import com.mapr.kafka.eventstreams.Admin;
import com.mapr.kafka.eventstreams.Streams;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.mapr.tools.KafkaMaprStreams;
import org.apache.kafka.mapr.tools.KafkaMaprfs;

public class KafkaMaprTools {
    protected static KafkaMaprTools tools = new KafkaMaprTools();

    public static KafkaMaprTools tools() {
        return tools;
    }

    public KafkaMaprfs maprfs() {
        return new KafkaMaprfs(this.getMapRFileSystem());
    }

    public KafkaMaprStreams streams() {
        return new KafkaMaprStreams(this.newStreamsAdmin());
    }

    public MapRFileSystem getMapRFileSystem() {
        try {
            return (MapRFileSystem)FileSystem.get((Configuration)new Configuration());
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public Admin newStreamsAdmin() {
        try {
            return Streams.newAdmin((Configuration)new Configuration());
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public String getCurrentUserName() {
        try {
            return UserGroupInformation.getCurrentUser().getUserName();
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public String getClusterAdminUserName() {
        try {
            return UserGroupInformation.getLoginUser().getUserName();
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }
}

