/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.mapr.tools;

import com.mapr.kafka.eventstreams.Admin;
import com.mapr.kafka.eventstreams.StreamDescriptor;
import com.mapr.kafka.eventstreams.Streams;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.mapr.tools.KafkaMaprTools;

public class KafkaMaprStreams
implements Closeable {
    private final Admin admin;
    public static final String PUBLIC_PERMISSIONS = "p";

    KafkaMaprStreams(Admin admin) {
        this.admin = admin;
    }

    public void createStreamForClusterAdmin(String streamName) {
        this.createStreamWithPerms(streamName, null, null);
    }

    public void createStreamForCurrentUser(String streamName) {
        String currentUserPerms = this.buildPermsForCurrentUser();
        this.createStreamWithPerms(streamName, currentUserPerms, currentUserPerms);
    }

    public void createStreamForAllUsers(String streamName) {
        this.createStreamWithPerms(streamName, PUBLIC_PERMISSIONS, PUBLIC_PERMISSIONS);
    }

    private String buildPermsForCurrentUser() {
        String clusterAdminUser = KafkaMaprTools.tools().getClusterAdminUserName();
        String currentUser = KafkaMaprTools.tools().getCurrentUserName();
        if (currentUser.equals(clusterAdminUser)) {
            return null;
        }
        return "u:" + clusterAdminUser + " | u:" + currentUser;
    }

    private StreamDescriptor createDescriptorWithPerms(String producerPerms, String consumerPerms) {
        StreamDescriptor streamDescriptor = Streams.newStreamDescriptor();
        if (producerPerms != null) {
            streamDescriptor.setProducePerms(producerPerms);
        }
        if (consumerPerms != null) {
            streamDescriptor.setConsumePerms(consumerPerms);
        }
        return streamDescriptor;
    }

    public void setStreamPerms(String streamName, String producerPerms, String consumerPerms) {
        try {
            StreamDescriptor desc = this.createDescriptorWithPerms(producerPerms, consumerPerms);
            this.admin.editStream(streamName, desc);
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public void createStreamWithPerms(String streamName, String producerPerms, String consumerPerms) {
        block2: {
            try {
                StreamDescriptor desc = this.createDescriptorWithPerms(producerPerms, consumerPerms);
                this.admin.createStream(streamName, desc);
            }
            catch (Exception e) {
                if (this.streamExists(streamName)) break block2;
                throw new KafkaException((Throwable)e);
            }
        }
    }

    public boolean streamHasPerms(String streamName, String producerPerm, String consumerPerm) {
        try {
            StreamDescriptor desc = this.admin.getStreamDescriptor(streamName);
            return Objects.equals(producerPerm, desc.getProducePerms()) && Objects.equals(consumerPerm, desc.getConsumePerms());
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public boolean streamExists(String streamName) {
        try {
            return this.admin.streamExists(streamName);
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public static String getShortTopicNameFromFullTopicName(String fullTopicName) {
        return fullTopicName.contains(":") ? StringUtils.substringAfter((String)fullTopicName, (String)":") : fullTopicName;
    }

    public void ensureStreamLogCompactionIsEnabled(String streamName) {
        try {
            StreamDescriptor desc = this.admin.getStreamDescriptor(streamName);
            if (!desc.getCompact()) {
                desc.setCompact(true);
                desc.setTimeToLiveSec(0L);
                this.admin.editStream(streamName, desc);
            }
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    @Override
    public void close() {
        this.admin.close();
    }
}

